/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duibaboot.ext.autoconfigure.core.DuibaServerProperties;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.web.FailFastFilter;
import cn.com.duibaboot.ext.autoconfigure.web.container.DuibaTomcatContextCustomizer;
import cn.com.duibaboot.ext.autoconfigure.web.container.JettyCustomizer;
import cn.com.duibaboot.ext.autoconfigure.web.container.TomcatCustomizer;
import cn.com.duibaboot.ext.autoconfigure.web.container.UndertowCustomizer;
import io.undertow.Undertow;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Resource;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.xnio.SslClientAuthMode;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={DuibaServerProperties.class})
@AutoConfigureBefore(value={EmbeddedServletContainerAutoConfiguration.class})
public class DuibaEmbeddedServletContainerAutoConfiguration {
    @Resource
    private DuibaServerProperties duibaServerProperties;

    @Bean
    public TomcatCustomizer tomcatCustomizer() {
        return new TomcatCustomizer(this.duibaServerProperties);
    }

    @Bean
    @ConditionalOnBean(value={UndertowEmbeddedServletContainerFactory.class})
    public UndertowCustomizer undertowCustomizer() {
        return new UndertowCustomizer(this.duibaServerProperties);
    }

    @Bean
    @ConditionalOnBean(value={JettyEmbeddedServletContainerFactory.class})
    public JettyCustomizer jettyCustomizer() {
        return new JettyCustomizer();
    }

    @Bean
    public static SpecifiedBeanPostProcessor servletContainerBeanPostProcessor() {
        return new SpecifiedBeanPostProcessor<AbstractEmbeddedServletContainerFactory>(){

            public int getOrder() {
                return 0;
            }

            @Override
            public Class<AbstractEmbeddedServletContainerFactory> getBeanType() {
                return AbstractEmbeddedServletContainerFactory.class;
            }

            @Override
            public Object postProcessBeforeInitialization(AbstractEmbeddedServletContainerFactory bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(AbstractEmbeddedServletContainerFactory bean, String beanName) throws BeansException {
                if (bean instanceof TomcatEmbeddedServletContainerFactory) {
                    TomcatEmbeddedServletContainerFactory tb = (TomcatEmbeddedServletContainerFactory)bean;
                    tb.addContextCustomizers(new TomcatContextCustomizer[]{new DuibaTomcatContextCustomizer()});
                }
                return bean;
            }
        };
    }

    @Bean
    public FilterRegistrationBean getFailFastFilter() {
        FailFastFilter filter2 = new FailFastFilter();
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)filter2);
        ArrayList<String> urlPatterns = new ArrayList<String>();
        urlPatterns.add("/*");
        registrationBean.setUrlPatterns(urlPatterns);
        registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
        registrationBean.setOrder(-2147483647);
        return registrationBean;
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, Undertow.class, SslClientAuthMode.class})
    @ConditionalOnMissingBean(value={EmbeddedServletContainerFactory.class}, search=SearchStrategy.CURRENT)
    public static class EmbeddedUndertow {
        @Bean
        public UndertowEmbeddedServletContainerFactory undertowEmbeddedServletContainerFactory() {
            return new UndertowEmbeddedServletContainerFactory();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, Server.class, Loader.class, WebAppContext.class})
    @ConditionalOnMissingBean(value={EmbeddedServletContainerFactory.class}, search=SearchStrategy.CURRENT)
    public static class EmbeddedJetty {
        @Bean
        public JettyEmbeddedServletContainerFactory jettyEmbeddedServletContainerFactory() {
            return new JettyEmbeddedServletContainerFactory();
        }
    }
}

