/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.nustaq.offheap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import shaded.org.nustaq.offheap.FreeList;
import shaded.org.nustaq.offheap.OffHeapByteTree;
import shaded.org.nustaq.offheap.bytez.ByteSource;
import shaded.org.nustaq.offheap.bytez.Bytez;
import shaded.org.nustaq.offheap.bytez.bytesource.BytezByteSource;
import shaded.org.nustaq.offheap.bytez.malloc.MMFBytez;
import shaded.org.nustaq.offheap.bytez.malloc.MallocBytezAllocator;

public class FSTBinaryOffheapMap {
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final int CUSTOM_FILEHEADER_LEN = 8000;
    public static final int CORE_HEADER_LEN = 8;
    public static final int FILE_HEADER_LEN = 8008;
    static final int HEADER_TAG = 58849;
    public static final int KEY_OFFSET_IN_HEADER = 16;
    private BytezByteSource tmpValueBytez;
    protected OffHeapByteTree index;
    protected Bytez memory;
    protected Bytez customHeader;
    protected MallocBytezAllocator alloc;
    protected int numElem;
    protected int keyLen;
    protected long bytezOffset;
    protected FreeList freeList;
    protected String mappedFile;
    protected int mutationCount;
    Thread debug;

    public FSTBinaryOffheapMap(String mappedFile, int keyLen, long sizeMemBytes, int numberOfElems) throws Exception {
        this.initFromFile(mappedFile, keyLen, sizeMemBytes, numberOfElems);
    }

    private void checkThread() {
    }

    public Bytez getCustomFileHeader() {
        return this.customHeader;
    }

    protected void initFromFile(String file, int keyLen, long sizeMemBytes, int numberOfElems) throws Exception {
        this.checkThread();
        this.numElem = 0;
        this.bytezOffset = 8008L;
        this.freeList = new FreeList();
        this.mappedFile = file;
        this.resetMem(file, sizeMemBytes);
        this.keyLen = keyLen;
        if (this.memory.getInt(4L) != 58849 || this.memory.getInt(0L) <= 0) {
            this.index = new OffHeapByteTree(keyLen, OffHeapByteTree.estimateMBytesForIndex(keyLen, numberOfElems));
            this.memory.putInt(4L, 58849);
        } else {
            this.numElem = this.memory.getInt(0L);
            this.index = new OffHeapByteTree(keyLen, OffHeapByteTree.estimateMBytesForIndex(keyLen, this.numElem * 2));
            long off = 8008L;
            int elemCount = 0;
            BytezByteSource byteIter = new BytezByteSource(this.memory, 0L, 0);
            while (elemCount < this.numElem) {
                boolean removed;
                int len = this.getLenFromHeader(off);
                boolean bl = removed = this.memory.get(off + 4L) != 0;
                if (!removed) {
                    ++elemCount;
                    byteIter.setOff(off + 16L);
                    byteIter.setLen(keyLen);
                    this.index.put(byteIter, off);
                    this.bytezOffset = off + (long)this.getHeaderLen() + (long)len;
                } else {
                    this.addToFreeList(off);
                }
                off += (long)(this.getHeaderLen() + len);
            }
        }
    }

    private void resetMem(String file, long sizeMemBytes) throws Exception {
        this.checkThread();
        ++this.mutationCount;
        this.memory = new MMFBytez(file, sizeMemBytes, false);
        this.customHeader = this.memory.slice(8L, 8000);
        this.tmpValueBytez = new BytezByteSource(this.memory, 0L, 0);
    }

    public FSTBinaryOffheapMap(int keyLen, long sizeMemBytes, int numberOfElems) {
        this.init(keyLen, sizeMemBytes, numberOfElems);
    }

    protected void init(int keyLen, long sizeMemBytes, int numberOfElems) {
        this.checkThread();
        this.numElem = 0;
        this.bytezOffset = 8008L;
        this.freeList = new FreeList();
        this.alloc = new MallocBytezAllocator();
        this.memory = this.alloc.alloc(sizeMemBytes);
        this.customHeader = this.memory.slice(8L, 8000);
        this.tmpValueBytez = new BytezByteSource(this.memory, 0L, 0);
        this.keyLen = keyLen;
        this.index = new OffHeapByteTree(keyLen, OffHeapByteTree.estimateMBytesForIndex(keyLen, numberOfElems));
        this.memory.putInt(4L, 58849);
    }

    protected void finalize() throws Throwable {
        this.free();
    }

    public void free() {
        this.checkThread();
        ++this.mutationCount;
        if (this.alloc != null) {
            this.alloc.freeAll();
            this.alloc = null;
        }
        if (this.memory instanceof MMFBytez) {
            ((MMFBytez)this.memory).freeAndClose();
            this.memory = null;
        }
        this.index = null;
    }

    public void putBinary(ByteSource key, ByteSource value) {
        this.checkThread();
        if (key.length() != (long)this.keyLen) {
            throw new RuntimeException("key must have length " + this.keyLen);
        }
        ++this.mutationCount;
        long put = this.index.get(key);
        if (put != 0L) {
            int lenFromHeader = this.getLenFromHeader(put);
            if (value.length() <= (long)lenFromHeader) {
                this.setEntry(put, lenFromHeader, value);
                this.index.put(key, put);
                return;
            }
            this.index.put(key, this.addEntry(key, value));
            this.removeEntry(put);
        } else {
            this.index.put(key, this.addEntry(key, value));
            this.incElems();
        }
    }

    protected void removeEntry(long offset) {
        this.checkThread();
        ++this.mutationCount;
        this.addToFreeList(offset);
        this.memory.put(offset + 4L, (byte)1);
    }

    protected void addToFreeList(long offset) {
        this.freeList.addToFree(offset, this.getLenFromHeader(offset) + this.getHeaderLen());
    }

    protected void setEntry(long off, int entryLen, ByteSource value) {
        this.checkThread();
        ++this.mutationCount;
        this.writeEntryHeader(off, entryLen, (int)value.length(), false);
        off += (long)this.getHeaderLen();
        int i = 0;
        while ((long)i < value.length()) {
            this.memory.put(off++, value.get(i));
            ++i;
        }
    }

    protected long addEntry(ByteSource key, ByteSource value) {
        this.checkThread();
        ++this.mutationCount;
        long valueLength = value.length();
        long newOffset = this.freeList.findFreeBlock((int)valueLength + this.getHeaderLen());
        if (newOffset > 0L) {
            int ii;
            this.writeEntryHeader(newOffset, this.getLenFromHeader(newOffset), (int)valueLength, false);
            long l = newOffset;
            for (ii = 0; ii < this.keyLen; ++ii) {
                this.memory.put(16L + l + (long)ii, key.get(ii));
            }
            l += (long)this.getHeaderLen();
            ii = 0;
            while ((long)ii < valueLength) {
                this.memory.put(l++, value.get(ii));
                ++ii;
            }
            return newOffset;
        }
        int entryLen = this.getEntryLengthForContentLength(value.length());
        entryLen = this.freeList.computeLen(entryLen + this.getHeaderLen()) - this.getHeaderLen();
        if (this.memory.length() <= this.bytezOffset + (long)entryLen + (long)this.getHeaderLen()) {
            this.resizeStore(this.bytezOffset + (long)entryLen + (long)this.getHeaderLen());
        }
        long res = this.bytezOffset;
        this.writeEntryHeader(this.bytezOffset, entryLen, (int)value.length(), false);
        for (int ii = 0; ii < this.keyLen; ++ii) {
            this.memory.put(16L + this.bytezOffset + (long)ii, key.get(ii));
        }
        long off = this.bytezOffset + (long)this.getHeaderLen();
        int i = 0;
        while ((long)i < value.length()) {
            this.memory.put(off++, value.get(i));
            ++i;
        }
        this.bytezOffset += (long)(entryLen + this.getHeaderLen());
        return res;
    }

    private void resizeStore(long required) {
        this.resizeStore(required, 0x40000000L);
    }

    public void resizeStore(long required, long maxgrowbytes) {
        if (this.mappedFile == null) {
            throw new RuntimeException("store is full. Required: " + required);
        }
        if (required <= this.memory.length()) {
            return;
        }
        ++this.mutationCount;
        System.out.println("resizing underlying " + this.mappedFile + " to " + required + " numElem:" + this.numElem);
        long tim = System.currentTimeMillis();
        ((MMFBytez)this.memory).freeAndClose();
        this.memory = null;
        try {
            File mf = new File(this.mappedFile);
            FileOutputStream f = new FileOutputStream(mf, true);
            long len = mf.length();
            required += Math.min(required, maxgrowbytes);
            byte[] toWrite = new byte[1000];
            long max = (required - len) / 1000L;
            for (long i = 0L; i < max + 2L; ++i) {
                f.write(toWrite);
            }
            f.flush();
            f.close();
            this.resetMem(this.mappedFile, mf.length());
            System.out.println("resizing done in " + (System.currentTimeMillis() - tim) + " numElemAfter:" + this.numElem);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BytezByteSource getBinary(ByteSource key) {
        this.checkThread();
        if (key.length() != (long)this.keyLen) {
            throw new RuntimeException("key must have length " + this.keyLen);
        }
        long aLong = this.index.get(key);
        if (aLong == 0L) {
            return null;
        }
        long off = aLong;
        int len = this.getContentLenFromHeader(off);
        this.tmpValueBytez.setLen(len);
        this.tmpValueBytez.setOff(off += (long)this.getHeaderLen());
        return this.tmpValueBytez;
    }

    public void removeBinary(ByteSource key) {
        this.checkThread();
        if (key.length() != (long)this.keyLen) {
            throw new RuntimeException("key must have length " + this.keyLen);
        }
        ++this.mutationCount;
        long rem = this.index.get(key);
        if (rem != 0L) {
            this.index.remove(key);
            this.decElems();
            this.removeEntry(rem);
        }
    }

    protected void decElems() {
        --this.numElem;
        this.memory.putInt(0L, this.numElem);
    }

    protected void incElems() {
        ++this.numElem;
        this.memory.putInt(0L, this.numElem);
    }

    protected int getEntryLengthForContentLength(long lengthOfEntry) {
        return (int)lengthOfEntry;
    }

    protected void writeEntryHeader(long offset, int entryLen, int contentLen, boolean removed) {
        this.checkThread();
        ++this.mutationCount;
        this.memory.putInt(offset, entryLen);
        this.memory.put(offset + 4L, (byte)(removed ? 1 : 0));
        this.memory.putInt(offset + 8L, contentLen);
        this.memory.putInt(offset + 12L, 58849);
    }

    protected int getHeaderLen() {
        return 16 + this.keyLen;
    }

    protected int getLenFromHeader(long off) {
        return this.memory.getInt(off);
    }

    protected int getContentLenFromHeader(long off) {
        return this.memory.getInt(off + 8L);
    }

    public Iterator<ByteSource> binaryValues() {
        this.checkThread();
        return new Iterator<ByteSource>(){
            long off = 8008L;
            int elemCount = 0;
            int mutSnap;
            BytezByteSource byteIter;
            {
                this.mutSnap = FSTBinaryOffheapMap.this.mutationCount;
                this.byteIter = new BytezByteSource(FSTBinaryOffheapMap.this.memory, 0L, 0);
            }

            @Override
            public boolean hasNext() {
                return this.elemCount < FSTBinaryOffheapMap.this.numElem;
            }

            @Override
            public ByteSource next() {
                FSTBinaryOffheapMap.this.checkThread();
                int contentLen = FSTBinaryOffheapMap.this.getContentLenFromHeader(this.off);
                int len = FSTBinaryOffheapMap.this.getLenFromHeader(this.off);
                boolean removed = FSTBinaryOffheapMap.this.memory.get(this.off + 4L) != 0;
                this.off += (long)FSTBinaryOffheapMap.this.getHeaderLen();
                while (removed) {
                    this.off += (long)len;
                    len = FSTBinaryOffheapMap.this.getLenFromHeader(this.off);
                    contentLen = FSTBinaryOffheapMap.this.getContentLenFromHeader(this.off);
                    removed = FSTBinaryOffheapMap.this.memory.get(this.off + 4L) != 0;
                    this.off += (long)FSTBinaryOffheapMap.this.getHeaderLen();
                }
                ++this.elemCount;
                this.byteIter.setOff(this.off);
                this.byteIter.setLen(contentLen);
                this.off += (long)len;
                if (this.mutSnap != FSTBinaryOffheapMap.this.mutationCount) {
                    throw new ConcurrentModificationException("in offheap map snap:" + this.mutSnap + " current:" + FSTBinaryOffheapMap.this.mutationCount);
                }
                return this.byteIter;
            }

            @Override
            public void remove() {
                throw new RuntimeException("unimplemented");
            }
        };
    }

    public String printBinaryKey(ByteSource key) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while ((long)i < key.length()) {
            byte b = key.get(i);
            if (b > 31) {
                res.append((char)b);
            } else {
                res.append('_');
            }
            ++i;
        }
        return res.toString();
    }

    public KeyValIter binaryKeys() {
        this.checkThread();
        return new KeyValIter(){
            long off = 8008L;
            int elemCount = 0;
            int mutSnap;
            BytezByteSource byteIter;
            BytezByteSource byteVal;
            long valueAddress;
            {
                this.mutSnap = FSTBinaryOffheapMap.this.mutationCount;
                this.byteIter = new BytezByteSource(FSTBinaryOffheapMap.this.memory, 0L, 0);
                this.byteVal = new BytezByteSource(FSTBinaryOffheapMap.this.memory, 0L, 0);
            }

            @Override
            public boolean hasNext() {
                return this.elemCount < FSTBinaryOffheapMap.this.numElem;
            }

            @Override
            public ByteSource next() {
                FSTBinaryOffheapMap.this.checkThread();
                int len = FSTBinaryOffheapMap.this.getLenFromHeader(this.off);
                int contentLen = FSTBinaryOffheapMap.this.getContentLenFromHeader(this.off);
                boolean removed = FSTBinaryOffheapMap.this.memory.get(this.off + 4L) != 0;
                this.off += (long)FSTBinaryOffheapMap.this.getHeaderLen();
                while (removed) {
                    this.off += (long)len;
                    len = FSTBinaryOffheapMap.this.getLenFromHeader(this.off);
                    contentLen = FSTBinaryOffheapMap.this.getContentLenFromHeader(this.off);
                    removed = FSTBinaryOffheapMap.this.memory.get(this.off + 4L) != 0;
                    this.off += (long)FSTBinaryOffheapMap.this.getHeaderLen();
                }
                ++this.elemCount;
                this.valueAddress = this.off;
                this.byteVal.setOff(this.off);
                this.byteVal.setLen(contentLen);
                this.byteIter.setOff(this.off - (long)FSTBinaryOffheapMap.this.getHeaderLen() + 16L);
                this.byteIter.setLen(FSTBinaryOffheapMap.this.keyLen);
                this.off += (long)len;
                if (this.mutSnap != FSTBinaryOffheapMap.this.mutationCount) {
                    throw new ConcurrentModificationException("in offheap map snap:" + this.mutSnap + " current:" + FSTBinaryOffheapMap.this.mutationCount);
                }
                return this.byteIter;
            }

            @Override
            public void remove() {
                throw new RuntimeException("unimplemented");
            }

            @Override
            public ByteSource getValueBytes() {
                return this.byteVal;
            }

            @Override
            public long getValueAddress() {
                return this.valueAddress;
            }
        };
    }

    public long getFreeMem() {
        return this.memory.length() - this.bytezOffset;
    }

    public long getUsedMem() {
        return this.bytezOffset;
    }

    public int getCapacityMB() {
        return (int)(this.memory.length() / 1024L / 1024L);
    }

    public int getSize() {
        return this.numElem;
    }

    public void dumpIndexStats() {
        this.index.dumpStats();
    }

    public String getFileName() {
        return this.mappedFile;
    }

    public static interface KeyValIter
    extends Iterator<ByteSource> {
        public ByteSource getValueBytes();

        public long getValueAddress();
    }
}

