package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.HttpClientMethodInterceptor;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultTransaction;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpUriRequest;

/**
 * 一个HttpClient方法拦截器的实现，用于给HttpClient加上cat统计功能
 */
class CatHttpClientMethodInterceptor implements HttpClientMethodInterceptor {

	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		if(!"execute".equals(invocation.getMethod().getName())){
			return invocation.proceed();
		}

		Object[] args = invocation.getArguments();
		HttpUriRequest httpUriRequest = null;
		HttpHost httpHost = null;
		for(Object arg : args){
			if(arg instanceof HttpUriRequest){
				httpUriRequest = (HttpUriRequest)arg;
				break;
			}else if(arg instanceof HttpHost){
				httpHost = (HttpHost)arg;
				break;
			}
		}

		String host;
		if(httpUriRequest != null) {
			host = httpUriRequest.getURI().getHost();
		}else if(httpHost != null){
			host = httpHost.getHostName();
		}else{
			return invocation.proceed();
		}

		if(!CatUtils.isCatEnabled()){
			return invocation.proceed();
		}

		Transaction transaction = Cat.newTransaction("HttpClient", host);
		try {
			return invocation.proceed();
		} catch (Throwable e) {
			//httpclient异常不记录到cat，不触发告警，以防对外部接口的调用有问题而触发大量告警。
			//失败单独记录, 但不幸的是，cat上不能直观地看到HttpClient的失败数
			((DefaultTransaction)transaction).setName(host + "(failed)");
			throw e;
		}finally{
			transaction.setStatus(Message.SUCCESS);
			transaction.complete();
		}
	}

	@Override
	public int getOrder() {
		return 0;
	}
}
