package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.boot.perftest.PerfTestContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

@Aspect
public class SleuthJestElasticSearchPlugin {

    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    /**
     * 拦截execute接口，记录执行耗时
     *
     * @param joinPoint
     * @return
     * @throws Throwable
     */
    @Around("execution(* io.searchbox.client.JestClient.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();

        if(!tracer.isTracing()){
            return joinPoint.proceed();
        }

        if (!"execute".equals(methodName) && !"executeAsync".equals(methodName)) {
            return joinPoint.proceed();
        } else {
            Span span = tracer.createSpan("elasticsearch:/"+methodName);
            try {
                if(span.isExportable()) {
                    span.tag("elasticsearch.class_method", "JestClient." + methodName);
                    span.tag(Span.SPAN_LOCAL_COMPONENT_TAG_NAME, "Jest");//本地组件名
                    span.tag(Span.SPAN_PEER_SERVICE_TAG_NAME, "Elasticsearch");//远程服务名
                    span.tag("isPerfTest", Boolean.toString(PerfTestContext.isCurrentInPerfTestMode()));
                    span.tag("thread", Thread.currentThread().getName());
                }
                span.logEvent(Span.CLIENT_SEND);

                return joinPoint.proceed();
            } catch(Exception e){
                errorParser.parseErrorTags(span, e);
                throw e;
            } finally {
                span.logEvent(Span.CLIENT_RECV);
                this.tracer.close(span);
            }
        }
    }

}
