package cn.com.duibaboot.ext.autoconfigure.flowreplay.record;

import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint.RecordConfigDto;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordStartEvent;

/**
 * 实例的录制上下文持有者
 * Created by guoyanfei .
 * 2019-02-22 .
 */
public final class RecordContextHolder {

    private RecordContextHolder() {
    }

    /**
     * 录制开关
     */
    private static volatile boolean recording = false;

    private static volatile RecordContext recordContext;

    /**
     * 录制进行中？
     * @return
     */
    public static boolean isRecording() {
        return recording && (recordContext != null);
    }

    /**
     * 开始录制
     * @param recordConfig
     */
    public synchronized static void start(RecordConfigDto recordConfig) {
        if (!isRecording()) {
            recording = true;
            recordContext = new RecordContext(recordConfig);
            FlowReplayFileComponent.initDir();
            recordContext.start();
            MainApplicationContextHolder.getApplicationContext().publishEvent(new RecordStartEvent());
        } else {
            throw new FlowReplayException("录制操作已经开始_请勿重复操作");
        }
    }

    /**
     * 正常结束
     */
    public static void normalEnd() {
        end(true, null);
    }

    /**
     * 异常结束
     * @param message
     */
    public static void abnormalEnd(String message) {
        end(false, message);
    }

    /**
     * 录制结束
     * @param normal
     * @param message
     */
    private synchronized static void end(boolean normal, String message) {
        if (isRecording()) {
            recording = false;
            recordContext.end();
            recordContext.recordFinished();
            MainApplicationContextHolder.getApplicationContext().publishEvent(new RecordEndEvent(normal, message));
        } else {
            throw new FlowReplayException("录制操作已经结束_请勿重复操作");
        }
    }

    /**
     * 获取实例的录制上下文
     * @return
     */
    public static RecordContext getRecordContext() {
        return recordContext;
    }

    /**
     * 获取录制开始时间
     * @return
     */
    public static Long getStartTime() {
        if (isRecording()) {
            return recordContext.getStartTime();
        }
        return null;
    }
}
