package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import com.alibaba.fastjson.JSONObject;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 流量录制结果查询
 */
public class RecordResultMvcEndpoint extends AbstractNamedMvcEndpoint {

    public RecordResultMvcEndpoint() {
        super("flow/record/result", "/flow/record/result", true);
    }

    @ResponseBody
    @RequestMapping(method = RequestMethod.GET)
    public String invoke(@RequestParam Long usecaseSetId) {
        JsonResult<JSONObject> result;
        try {
            RecordContext context = RecordContextHolder.getRecordContext();
            if (context == null) {
                throw new FlowReplayException("录制未开始");
            }
            if (!usecaseSetId.equals(context.getUsecaseSetId())) {
                throw new FlowReplayException("非法的用例集ID");
            }
            JSONObject recordResult = new JSONObject();
            if (!RecordContextHolder.isRecording() && context.getRecordResult() != null) {
                recordResult.put("isEnded", true);
                recordResult.put("result", context.getRecordResult());
            } else {
                recordResult.put("isEnded", false);
                recordResult.put("result", null);
            }
            result = JsonResult.successResult(recordResult);
        } catch (Exception e) {
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }

}
