package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.RemoteServiceFlowReplaySpan;
import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

import javax.annotation.Resource;
import java.lang.reflect.Method;

/**
 * RemoteService 的回归器
 * Created by guoyanfei .
 * 2019-02-26 .
 */
public class RemoteServiceReplayer implements Replayer {

    private final static Gson gson = new Gson();

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public ReplayTraceResult replay(FlowReplayTrace trace) {
        RemoteServiceFlowReplaySpan span = (RemoteServiceFlowReplaySpan) trace.getMainSpan();
        Object obj = applicationContext.getBean(toLowerCaseFirstOne(span.getTypeName()));

        // 创建回归详情trace(等同一次录制)
        FlowReplayTrace.cleanRecordEnv();
        RemoteServiceFlowReplaySpan mainSpan = RemoteServiceFlowReplaySpan.createSpan(span);
        FlowReplayTrace.createReplayTrace(mainSpan, trace.getTraceId());

        ReplayTraceContext.create(trace, FlowReplayTrace.get());
        ReplayTraceContext context = null;
        Object replayResultValue = null;
        try {
            String[] parameterTypes = span.getParameterTypes();
            int parameterLength = parameterTypes.length;
            Class<?>[] parameterTypeClasses = null;
            if (parameterLength > 0) {
                parameterTypeClasses = new Class[parameterLength];
                for (int i = 0; i < parameterLength; i++) {
                    parameterTypeClasses[i] = transformClass(parameterTypes[i]);
                }
            }
            Method method = ReflectionUtils.findMethod(obj.getClass(), span.getMethodName(), parameterTypeClasses);
            replayResultValue = ReflectionUtils.invokeMethod(method, obj, span.getParameterValues());
        } catch (ClassNotFoundException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_300, e);
        } finally {
            context = ReplayTraceContext.getAndRemove();
        }
        if (context == null) {
            throw new FlowReplayException("单个用例回归上下文丢失_traceId=" + trace.getTraceId());
        }
        if (context.isErrorMarked()) {
            return ReplayTraceResult.failResult(trace, context.getReplayDetailTrace(), context.getErrorMsgType(), context.getErrorMsgDetail(), context.getStepDiffColumns());
        }

        JsonElement pTemp = gson.toJsonTree(replayResultValue);
        Object replayResultValueJson = JSON.parse(pTemp.toString());
        mainSpan.setReturnValue(replayResultValueJson); // 回归详情的返回值回填
        return ReplayTraceResult.successResult(trace, context.getReplayDetailTrace(), replayResultValueJson, context.getStepDiffColumns());
    }

    private Class<?> transformClass(String type) throws ClassNotFoundException {
        switch (type) {
            case "long":
                return long.class;
            case "int":
                return int.class;
            case "short":
                return short.class;
            case "float":
                return float.class;
            case "double":
                return double.class;
            case "boolean":
                return boolean.class;
            case "char":
                return char.class;
            case "byte":
                return byte.class;
            default:
                return Class.forName(type);
        }
    }

    /**
     * 字符串首字母小写
     * @param s
     * @return
     */
    private static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        } else {
            return Character.toLowerCase(s.charAt(0)) + s.substring(1);
        }
    }

}
