package cn.com.duibaboot.ext.autoconfigure.logger;

import org.springframework.boot.logging.logback.LogbackLoggingSystem;

/**
 * LogbackLoggingSystem会在/refresh的时候重新加载，导致kafka log、accesslog等失效（并且重新加载期间日志打印会有问题）。禁止logback重新加载
 */
public class NonRefreshLogbackLoggingSystem extends LogbackLoggingSystem {

    private static volatile boolean canCleanUp = true;

    public NonRefreshLogbackLoggingSystem(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public void cleanUp() {
        if(canCleanUp) {
            super.cleanUp();
        }
    }

    /**
     * 设置是否可以清理LoggingSystem.
     * @param canCleanUp
     */
    public static void setCanCleanUp(boolean canCleanUp){
        NonRefreshLogbackLoggingSystem.canCleanUp = canCleanUp;
    }
}
