/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.batch;

import cn.com.duibaboot.ext.autoconfigure.batch.BatchProperties;
import cn.com.duibaboot.ext.autoconfigure.batch.MergeRequest;
import cn.com.duibaboot.ext.autoconfigure.batch.ReqBucket;
import cn.com.duibaboot.ext.autoconfigure.batch.ReqContext;
import java.lang.reflect.Method;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

@Aspect
public class ReqInterceptor {
    @Resource
    private BatchProperties properties;
    @Resource
    private ReqBucket reqBucket;

    @Around(value="@annotation(cn.com.duibaboot.ext.autoconfigure.batch.MergeRequest)")
    public Object merge(ProceedingJoinPoint joinPoint) throws Throwable {
        Object ret;
        if (!this.properties.isEnable()) {
            return joinPoint.proceed();
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        MergeRequest merge = (MergeRequest)AnnotationUtils.getAnnotation((Method)signature.getMethod(), MergeRequest.class);
        if (merge == null) {
            return joinPoint.proceed();
        }
        if (StringUtils.isEmpty((Object)merge.method())) {
            return joinPoint.proceed();
        }
        ReqContext req = new ReqContext(joinPoint.getArgs(), joinPoint.getTarget(), merge);
        try {
            ret = this.submitRequest(req);
        }
        catch (RejectedExecutionException e) {
            return joinPoint.proceed();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object submitRequest(ReqContext req) throws Throwable {
        this.reqBucket.submit(req);
        if (req.getAnnotation().oneway()) {
            return null;
        }
        ReqContext reqContext = req;
        synchronized (reqContext) {
            req.wait(req.getAnnotation().timeout());
        }
        if (req.getState() != 2) {
            throw new TimeoutException(req.getFullMethodName() + " " + req.getAnnotation().timeout() + "ms");
        }
        return req.getResult();
    }
}

