/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.boot.utils.JarVersionUtils;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PerfTestRibbonServerListFilter
implements RibbonServerListFilter {
    public List<Server> filter(List<Server> serverList, Object key) {
        if (serverList.isEmpty()) {
            return serverList;
        }
        for (Server s : serverList) {
            if (s instanceof DiscoveryEnabledServer) continue;
            return serverList;
        }
        boolean perfTestMode = InternalPerfTestContext.isCurrentInPerfTestMode();
        String contextSceneId = InternalPerfTestContext.getCurrentSceneId();
        boolean isTestCluster = InternalPerfTestContext.isTestCluster();
        ArrayList<Server> testList = new ArrayList<Server>(serverList.size());
        ArrayList<Server> prodList = new ArrayList<Server>(serverList.size());
        for (Server server : serverList) {
            String duibaBootVersion;
            String serverPerfSceneId = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("duiba.perf.scene.id");
            if (perfTestMode && isTestCluster && this.sceneIdEquals(contextSceneId, serverPerfSceneId) && JarVersionUtils.isJarVersionEqualOrGreaterThan((String)(duibaBootVersion = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("duibaBootVersion")), (String)"1.2.251")) {
                testList.add(server);
            }
            if (!StringUtils.isBlank((CharSequence)serverPerfSceneId)) continue;
            prodList.add(server);
        }
        if (CollectionUtils.isNotEmpty(testList)) {
            return testList;
        }
        return CollectionUtils.isNotEmpty(prodList) ? prodList : serverList;
    }

    private boolean sceneIdEquals(String contextSceneId, String serverSceneId) {
        if (contextSceneId == null || serverSceneId == null) {
            return false;
        }
        return contextSceneId.equals(serverSceneId);
    }
}

