/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class FlowReplayFileComponent {
    private static final Logger log = LoggerFactory.getLogger(FlowReplayFileComponent.class);
    private final RestTemplate loadBalancedRestTemplate;

    public FlowReplayFileComponent(RestTemplate loadBalancedRestTemplate) {
        this.loadBalancedRestTemplate = loadBalancedRestTemplate;
    }

    public String upload(String localPath) throws IOException {
        String localZipFileName = "/data/flowreplay/" + System.currentTimeMillis() + ".zip";
        File localFile = new File(localPath);
        File localZipFile = new File(localZipFileName);
        try (FileOutputStream os = new FileOutputStream(localZipFile);
             ZipOutputStream zipos = new ZipOutputStream(os);){
            this.compressFileToZip(localFile, zipos, localFile.getName());
        }
        FileSystemResource resource = new FileSystemResource(localZipFile);
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add((Object)"file", (Object)resource);
        return (String)this.loadBalancedRestTemplate.postForObject("http://athena-web/athena/file/upload", (Object)multiValueMap, String.class, new Object[0]);
    }

    private void compressFileToZip(File sourceFile, ZipOutputStream zipos, String fileName) throws IOException {
        byte[] buffer = new byte[1024];
        if (sourceFile.isFile()) {
            zipos.putNextEntry(new ZipEntry(fileName));
            try (FileInputStream is = new FileInputStream(sourceFile);
                 BufferedInputStream bis = new BufferedInputStream(is);){
                int i = bis.read(buffer);
                while (i != -1) {
                    zipos.write(buffer, 0, i);
                    i = bis.read(buffer);
                }
            }
            zipos.closeEntry();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                zipos.putNextEntry(new ZipEntry(fileName + "/"));
                zipos.closeEntry();
            } else {
                for (File subFile : listFiles) {
                    this.compressFileToZip(subFile, zipos, fileName + "/" + subFile.getName());
                }
            }
        }
    }

    public String download(String ossPath, String localDir) throws IOException {
        if (StringUtils.isBlank((CharSequence)ossPath) || StringUtils.isBlank((CharSequence)localDir)) {
            throw new FlowReplayException("\u6587\u4ef6\u4e0b\u8f7d\u53c2\u6570\u4e0d\u5168");
        }
        ResponseEntity response = this.loadBalancedRestTemplate.getForEntity("http://athena-web/athena/file/download?objectName=" + ossPath, Resource.class, new Object[0]);
        InputStream input = ((Resource)response.getBody()).getInputStream();
        String newFilePath = (localDir.endsWith("/") ? localDir : localDir + "/") + System.currentTimeMillis();
        try (ZipInputStream zipInputStream = new ZipInputStream(input);
             FileOutputStream fileOutputStream = new FileOutputStream(newFilePath);){
            int len;
            zipInputStream.getNextEntry();
            byte[] buf = new byte[1024];
            while ((len = zipInputStream.read(buf, 0, 1024)) != -1) {
                fileOutputStream.write(buf, 0, len);
            }
        }
        return newFilePath;
    }

    public void clearFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists() || file.isDirectory()) {
            return;
        }
        try (FileWriter fw = new FileWriter(file);){
            fw.write("");
            fw.flush();
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u6e05\u7a7a\u5f02\u5e38,filePath={}", (Object)filePath, (Object)e);
        }
    }

    public static void initDir() {
        File dir = new File("/data/flowreplay/");
        try {
            FileUtils.deleteDirectory((File)dir);
            FileUtils.forceMkdir((File)dir);
        }
        catch (IOException e) {
            log.error("\u521d\u59cb\u5316/data/flowreplay\u76ee\u5f55\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void removeDir() {
        File dir = new File("/data/flowreplay/");
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            log.error("\u521d\u59cb\u5316/data/flowreplay\u76ee\u5f55\u5f02\u5e38", (Throwable)e);
        }
    }
}

