/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.cloud.sleuth.zipkin2.ZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;

public class ZipkinLoadBalancerBeanPostProcessor
implements SpecifiedBeanPostProcessor<ZipkinLoadBalancer>,
BeanFactoryAware {
    private BeanFactory beanFactory;

    @Override
    public Class<ZipkinLoadBalancer> getBeanType() {
        return ZipkinLoadBalancer.class;
    }

    @Override
    public Object postProcessBeforeInitialization(ZipkinLoadBalancer bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(ZipkinLoadBalancer bean, String beanName) throws BeansException {
        return new ZipkinLoadBalancerUsingAnotherPort(bean, this.beanFactory);
    }

    public int getOrder() {
        return 0;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private static class ZipkinLoadBalancerUsingAnotherPort
    implements ZipkinLoadBalancer {
        private ZipkinLoadBalancer delegate;
        private BeanFactory beanFactory;
        private volatile Integer zipkinPort;

        public ZipkinLoadBalancerUsingAnotherPort(ZipkinLoadBalancer delegate, BeanFactory beanFactory) {
            this.delegate = delegate;
            this.beanFactory = beanFactory;
        }

        public URI instance() {
            URI uri = this.delegate.instance();
            if (this.getZipkinPort() != null && uri.getPort() != this.getZipkinPort().intValue()) {
                try {
                    uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), this.getZipkinPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return uri;
        }

        private Integer getZipkinPort() {
            if (this.zipkinPort == null) {
                ZipkinProperties zipkinProperties = (ZipkinProperties)this.beanFactory.getBean(ZipkinProperties.class);
                URI uri = URI.create(zipkinProperties.getBaseUrl());
                this.zipkinPort = uri.getPort();
            }
            return this.zipkinPort;
        }
    }
}

