/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.CaffeineCacheFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RecordCaffeineCacheMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RecordCaffeineCacheMethodInterceptor.class);

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        String methodName = method.getName();
        Assert.state(("build".equals(methodName) || "buildAsync".equals(methodName) ? 1 : 0) != 0, (String)"method name must be 'build', will not be here");
        int parameterCount = method.getParameterCount();
        if ("buildAsync".equals(methodName) && parameterCount == 1) {
            return ret;
        }
        if ("build".equals(methodName) && parameterCount == 0) {
            Cache cache = (Cache)ret;
            return new RecordLocalCache(cache);
        }
        if ("build".equals(methodName) && parameterCount == 1) {
            LoadingCache cache = (LoadingCache)ret;
            return new RecordLocalLoadingCache((Cache)cache);
        }
        throw new IllegalStateException("will never be here");
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    private static <T> T executeRecord(String methodName, Object key, Callback<T> callback) {
        T v;
        if (!RecordCaffeineCacheMethodInterceptor.canRecord(key)) {
            return callback.invoke();
        }
        Object[] allArguments = new Object[]{key};
        Class[] argumentsTypes = new Class[]{key.getClass()};
        IgnoreSubInvokesContext.instMark(callback, methodName, allArguments);
        try {
            v = callback.invoke();
        }
        catch (Throwable t) {
            FlowReplayTrace.remove();
            IgnoreSubInvokesContext.unmark();
            throw t;
        }
        RecordCaffeineCacheMethodInterceptor.record(methodName, allArguments, argumentsTypes, v);
        return v;
    }

    private static boolean canRecord(Object arg) {
        if (!FlowReplayTrace.isTraced()) {
            return false;
        }
        if (arg instanceof Iterable) {
            for (Object o : (Iterable)arg) {
                if (o == null || !FlowReplayConstants.CANNOT_DESERIALIZE_CLASSES.contains(o.getClass().getName())) continue;
                return false;
            }
        }
        if (FlowReplayConstants.CANNOT_DESERIALIZE_CLASSES.contains(arg.getClass().getName())) {
            return false;
        }
        return !IgnoreSubInvokesContext.isMarked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void record(String methodName, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        try {
            CaffeineCacheFlowReplaySpan span = CaffeineCacheFlowReplaySpan.createSpan(methodName, allArguments, argumentsTypes, ret);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
        }
        catch (Throwable t) {
            log.error("CaffeineCache_\u5f55\u5236\u5f02\u5e38", t);
            FlowReplayTrace.remove();
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
    }

    private static interface Callback<R> {
        public R invoke();
    }

    static class RecordLocalLoadingCache<K, V>
    extends RecordLocalCache<K, V>
    implements LoadingCache<K, V> {
        private RecordLocalLoadingCache(Cache<K, V> cache) {
            super(cache);
        }

        @Override
        protected LoadingCache<K, V> getCache() {
            return (LoadingCache)super.getCache();
        }

        @CheckForNull
        public V get(@Nonnull K key) {
            return (V)RecordCaffeineCacheMethodInterceptor.executeRecord("get", key, () -> this.getCache().get(key));
        }

        @Nonnull
        public Map<K, V> getAll(@Nonnull Iterable<? extends K> keys) {
            return (Map)RecordCaffeineCacheMethodInterceptor.executeRecord("getAll", keys, () -> this.getCache().getAll(keys));
        }

        public void refresh(@Nonnull K key) {
            this.getCache().refresh(key);
        }
    }

    static class RecordLocalCache<K, V>
    implements Cache<K, V> {
        private Cache<K, V> cache;

        private RecordLocalCache(Cache<K, V> cache) {
            this.cache = cache;
        }

        protected Cache<K, V> getCache() {
            return this.cache;
        }

        @CheckForNull
        public V getIfPresent(@Nonnull Object key) {
            return (V)RecordCaffeineCacheMethodInterceptor.executeRecord("getIfPresent", key, () -> this.getCache().getIfPresent(key));
        }

        @CheckForNull
        public V get(@Nonnull K key, @Nonnull Function<? super K, ? extends V> mappingFunction) {
            return (V)RecordCaffeineCacheMethodInterceptor.executeRecord("get", key, () -> this.getCache().get(key, mappingFunction));
        }

        @Nonnull
        public Map<K, V> getAllPresent(@Nonnull Iterable<?> keys) {
            return (Map)RecordCaffeineCacheMethodInterceptor.executeRecord("getAllPresent", keys, () -> this.getCache().getAllPresent(keys));
        }

        public void put(@Nonnull K key, @Nonnull V value) {
            this.getCache().put(key, value);
        }

        public void putAll(@Nonnull Map<? extends K, ? extends V> map) {
            this.getCache().putAll(map);
        }

        public void invalidate(@Nonnull Object key) {
            this.getCache().invalidate(key);
        }

        public void invalidateAll(@Nonnull Iterable<?> keys) {
            this.getCache().invalidateAll(keys);
        }

        public void invalidateAll() {
            this.getCache().invalidateAll();
        }

        public long estimatedSize() {
            return this.getCache().estimatedSize();
        }

        @Nonnull
        public CacheStats stats() {
            return this.getCache().stats();
        }

        @Nonnull
        public ConcurrentMap<K, V> asMap() {
            return this.getCache().asMap();
        }

        public void cleanUp() {
            this.getCache().cleanUp();
        }

        @Nonnull
        public Policy<K, V> policy() {
            return this.getCache().policy();
        }
    }
}

