/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReplayTraceContextMapHolder {
    private static Map<String, ReplayTraceContextBlockingWrapper> contextMap = new ConcurrentHashMap<String, ReplayTraceContextBlockingWrapper>();

    public static void preset(String traceId) {
        contextMap.putIfAbsent(traceId, new ReplayTraceContextBlockingWrapper());
    }

    public static ReplayTraceContext getAndRemove(String traceId) {
        ReplayTraceContextBlockingWrapper context0 = contextMap.get(traceId);
        if (context0 == null) {
            return null;
        }
        ReplayTraceContext context = context0.get();
        contextMap.remove(traceId);
        return context;
    }

    public static void put(ReplayTraceContext replayTraceContext) {
        ReplayTraceContextBlockingWrapper context = contextMap.get(replayTraceContext.getTraceId());
        if (context == null) {
            return;
        }
        context.set(replayTraceContext);
    }

    private static class ReplayTraceContextBlockingWrapper {
        private ReplayTraceContext replayTraceContext;
        private boolean filled = false;

        private ReplayTraceContextBlockingWrapper() {
        }

        public synchronized void set(ReplayTraceContext replayTraceContext) {
            if (this.filled) {
                return;
            }
            this.replayTraceContext = replayTraceContext;
            this.filled = true;
            this.notifyAll();
        }

        public synchronized ReplayTraceContext get() {
            while (!this.filled) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.replayTraceContext;
        }
    }
}

