/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMetricsCollector;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorConstant;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorExclude;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorManager;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorMvcEndpoint;
import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.PushGateway;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class CacheMonitorAutoConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(CacheMonitorAutoConfiguration.class);
    @Value(value="${spring.application.name}")
    private String currentAppName;
    @Value(value="${server.port}")
    private int httpServerPort;
    @Value(value="${prometheus.pushgateway.address:}")
    private String pushGatewayAddress;
    private static final CollectorRegistry collectorRegistry = CollectorRegistry.defaultRegistry;
    private static final CacheMetricsCollector cacheMetrics = (CacheMetricsCollector)new CacheMetricsCollector().register(collectorRegistry);
    @Resource
    private ApplicationContext appContext;
    private static final String localIp = NetUtils.getLocalIp();
    private final String prometheusJobName = "cache_monitor";
    private ScheduledExecutorService scheduledThreadPool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("duiba-pushgateway-cache", true));

    @Bean
    public static SpecifiedBeanPostProcessor cacheMonitorBeanPostProcessor(final ApplicationContext appContext, final @Value(value="${spring.application.name}") String currentAppName) {
        return new SpecifiedBeanPostProcessor<Object>(){
            volatile String curEnv;

            public int getOrder() {
                return 0;
            }

            @Override
            public Class<Object> getBeanType() {
                return Object.class;
            }

            @Override
            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (this.curEnv == null) {
                    this.curEnv = SpringEnvironmentUtils.getCurrentEnv((ApplicationContext)appContext);
                }
                try {
                    Class<?> beanObjClass = bean.getClass();
                    if (beanObjClass.getAnnotation(CacheMonitorExclude.class) != null) {
                        return bean;
                    }
                    Package pkg = beanObjClass.getPackage();
                    if (pkg == null) {
                        return bean;
                    }
                    String packageName = pkg.getName();
                    if (packageName.startsWith("springfox.") || packageName.startsWith("org.") || packageName.startsWith("io.") || packageName.startsWith("net.") || packageName.startsWith("cn.com.duibaboot") || packageName.startsWith("com.netflix")) {
                        return bean;
                    }
                    Field[] fields = bean.getClass().getDeclaredFields();
                    if (fields.length == 0) {
                        return bean;
                    }
                    CacheMonitorAutoConfiguration.addCache(fields, beanName, bean, this.curEnv, currentAppName);
                }
                catch (Exception e) {
                    log.warn("", (Throwable)e);
                }
                return bean;
            }
        };
    }

    @Async
    @EventListener(value={MainContextRefreshedEvent.class})
    public void loadAllCacheBean() {
        this.pushRecord();
    }

    @EventListener(value={EnvironmentChangeEvent.class})
    public void changeRecord() {
        CacheMonitorManager.changeOpenRecord();
        if (this.isClose()) {
            this.scheduledThreadPool.shutdown();
            return;
        }
        if (this.scheduledThreadPool.isShutdown() || this.scheduledThreadPool.isTerminated()) {
            this.scheduledThreadPool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("duiba-pushgateway-cache", true));
        }
        this.pushRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCache(Field[] fields, String beanName, Object beanObj, String curEnv, String currentAppName) {
        for (Field field : fields) {
            if (field.getAnnotation(CacheMonitorExclude.class) != null) continue;
            boolean isGuava = Cache.class.isAssignableFrom(field.getType());
            boolean isCaffeine = com.github.benmanes.caffeine.cache.Cache.class.isAssignableFrom(field.getType());
            if (!isGuava && !isCaffeine) continue;
            field.setAccessible(true);
            String keyName = String.format("%s-%s", beanName, field.getName());
            try {
                Object cache = field.get(beanObj);
                CacheMonitorManager.saveCache(cache, keyName);
                cacheMetrics.addCache(keyName, cache, localIp, currentAppName, curEnv);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    private void pushRecord() {
        if (this.isClose()) {
            return;
        }
        if (cacheMetrics.getSize() == 0L) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.pushGatewayAddress)) {
            return;
        }
        if (this.scheduledThreadPool.isShutdown()) {
            return;
        }
        PushGateway pushGateway = new PushGateway(this.pushGatewayAddress);
        HashMap groupingKey = Maps.newHashMap();
        groupingKey.put("ip", localIp);
        this.scheduledThreadPool.scheduleAtFixedRate(() -> {
            try {
                pushGateway.pushAdd(collectorRegistry, "cache_monitor", groupingKey);
            }
            catch (Exception e) {
                log.debug("\u63a8\u9001\u6307\u6807\u5230pushgateway\u5f02\u5e38", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    private boolean isClose() {
        Environment environment = this.appContext.getEnvironment();
        String isMonitorCloseVal = environment.getProperty(CacheMonitorConstant.CACHE_MONITOR_CLOSE_KEY);
        return Boolean.parseBoolean(isMonitorCloseVal);
    }

    public void afterPropertiesSet() {
        Environment environment = this.appContext.getEnvironment();
        CacheMonitorManager.init(environment, this.currentAppName, this.httpServerPort);
    }

    @Configuration
    public static class CacheMonitorEndpointConfiguration {
        @Bean
        public CacheMonitorMvcEndpoint cacheMonitorEndpointConfiguration() {
            return new CacheMonitorMvcEndpoint();
        }
    }
}

