/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.profiler;

import cn.com.duiba.wolf.dubbo.InitOperation;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.profiler.TimeProfileAspect;
import cn.com.duibaboot.ext.autoconfigure.profiler.TimeProfileProperties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@ConditionalOnClass(value={DBTimeProfile.class})
@EnableConfigurationProperties(value={TimeProfileProperties.class})
public class TimeProfilerAutoConfiguration {
    @Resource
    private TimeProfileProperties timeProfileProperties;

    @Bean
    public TimeProfileAspect timeProfileAspect() {
        return new TimeProfileAspect();
    }

    @PostConstruct
    public void init() {
        InitOperation.init();
        this.changeTimeProfileThreshold();
    }

    @EventListener(value={EnvironmentChangeEvent.class})
    @Order(value=0x7FFFFFFF)
    public void changeTimeProfileThreshold() {
        Integer threshold = this.timeProfileProperties.getThreshold();
        if (threshold != null) {
            DBTimeProfile.setThreshold((int)threshold);
        }
    }
}

