package cn.com.duibaboot.ext.autoconfigure.batch;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(BatchProperties.class)
@ConditionalOnProperty(value = "duiba.merge.request.enable", havingValue = "true")
public class BatchAutoConfiguration {

    @Bean
    public ReqInterceptor getReqInterceptor() {
        return new ReqInterceptor();
    }

    @Bean
    public ReqPacker getReqPacker() {
        return new ReqPacker();
    }

    @Bean
    public BatchHandler getBatchHandler() {
        return new BatchHandler();
    }

    @Bean
    public ReqBucket getReqBucket() {
        return new ReqBucket();
    }

}
