package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.internal.DefaultTransaction;
import io.searchbox.client.JestResultHandler;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

/**
 * 加入AOP，监控jest(ElasticSearch客户端)执行耗时
 */
@Aspect
public class CatJestElasticSearchPlugin {

	private static final String space = "Jest";

	/**
	 * 拦截execute接口，记录执行耗时
	 * 
	 * @param joinPoint
	 * @return
	 * @throws Throwable
	 */
	@Around("execution(* io.searchbox.client.JestClient.*(..))")
	public Object jestJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
		MethodSignature signature = (MethodSignature) joinPoint.getSignature();
		String methodName = signature.getMethod().getName();
		if(!CatUtils.isCatEnabled()) {
			return joinPoint.proceed();
		}

		if("execute".equals(methodName)) {
			return CatUtils.executeInCatTransaction(() -> joinPoint.proceed(), space, methodName);
		} else if ("executeAsync".equals(methodName) && joinPoint.getArgs().length >= 2
				&& joinPoint.getArgs()[1] instanceof JestResultHandler) {
			JestResultHandler handler = (JestResultHandler) joinPoint.getArgs()[1];
			joinPoint.getArgs()[1] = new CatJestResultHandler(handler);

			return joinPoint.proceed(joinPoint.getArgs());
		} else {
			return joinPoint.proceed();
		}
	}

	public static class CatJestResultHandler implements JestResultHandler {

		private JestResultHandler original;
		private long start;

		public CatJestResultHandler(JestResultHandler original) {
			this.original = original;
			this.start = System.nanoTime();
		}

		@Override
		public void completed(Object result) {
			DefaultTransaction transaction = (DefaultTransaction) Cat.newTransaction(space, "executeAsync");
			transaction.setDurationStart(start);
			transaction.setStatus(Message.SUCCESS);
			transaction.complete();

			original.completed(result);
		}

		@Override
		public void failed(Exception ex) {
			DefaultTransaction transaction = (DefaultTransaction) Cat.newTransaction(space, "executeAsync");
			transaction.setDurationStart(start);
			transaction.setStatus(ex);
			transaction.complete();

			original.failed(ex);
		}
	}

}
