package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import cn.com.duibaboot.ext.autoconfigure.core.Constants;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Optional;

/**
 * 用于录制在调试模式下的参数
 */
public class DuibaRpcParamsInterceptor extends HandlerInterceptorAdapter {

    @Autowired
    private Tracer tracer;

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if(!DuibaTraceSecondFilter.isDebugMode()){
            return;
        }
        String flages = (String) Optional.ofNullable(request.getAttribute(Span.SPAN_FLAGS)).orElse(Span.SPAN_NOT_SAMPLED);
        Span span = tracer.getCurrentSpan();
        if(StringUtils.equals(flages,Span.SPAN_SAMPLED)){
            JSONObject json = new JSONObject();
            json.putAll(request.getParameterMap());
            json.remove(DuibaTraceFilter.ZIPKIN_MODEL);
            span.tag("RequestParams",json.toJSONString());
        }
        List argList = (List)request.getAttribute(Constants.HTTP_REQUEST_ATTRIBUTE_RPC_ARGS);
        if(argList!=null && !argList.isEmpty()){
            JSONObject json = new JSONObject(argList.size(), true);
            int i = 0;
            for(Object arg:argList){
                json.put(String.valueOf(i++), Optional.ofNullable(arg).orElse("null"));
            }
            span.tag("RpcRequestParams",json.toJSONString());
        }
    }

}
