package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import java.net.URI;
import java.net.URISyntaxException;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.cloud.sleuth.zipkin2.ZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;

/**
 * 由于新版zipkin服务器使用了自定义的9412端口号，而zipkin注册到eureka的是9411端口号，本代理强制把访问zipkin的端口号改为9412
 */
public class ZipkinLoadBalancerBeanPostProcessor implements SpecifiedBeanPostProcessor<ZipkinLoadBalancer> {

	private int zipkinPort;

	public ZipkinLoadBalancerBeanPostProcessor(int zipkinPort) {
		this.zipkinPort = zipkinPort;
	}

	@Override
	public Class<ZipkinLoadBalancer> getBeanType() {
		return ZipkinLoadBalancer.class;
	}

	@Override
	public Object postProcessBeforeInitialization(ZipkinLoadBalancer bean, String beanName) throws BeansException {
		return bean;
	}

	@Override
	public Object postProcessAfterInitialization(ZipkinLoadBalancer bean, String beanName) throws BeansException {
		return new ZipkinLoadBalancerUsingAnotherPort(bean, zipkinPort);
	}

	@Override
	public int getOrder() {
		return 0;
	}

	/**
	 * 由于新版zipkin服务器使用了自定义的9412端口号，而zipkin注册到eureka的是9411端口号，本代理强制把访问zipkin的端口号改为9412
	 */
	private static class ZipkinLoadBalancerUsingAnotherPort implements ZipkinLoadBalancer {

		private ZipkinLoadBalancer delegate;
		private int zipkinPort;

		public ZipkinLoadBalancerUsingAnotherPort(ZipkinLoadBalancer delegate, int zipkinPort) {
			this.delegate = delegate;
			this.zipkinPort = zipkinPort;
		}

		@Override
		public URI instance() {
			URI uri = delegate.instance();
			if(uri.getPort() != zipkinPort) {
				try {
					uri = new URI(uri.getScheme(), uri.getUserInfo(),
							uri.getHost(), zipkinPort, uri.getPath(),
							uri.getQuery(), uri.getFragment());
				}
				catch (URISyntaxException e) {
					//Ignore
				}
			}

			return uri;
		}

	}
}
