package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.config;

import java.util.HashMap;
import java.util.Map;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import com.google.common.annotations.VisibleForTesting;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

/**
 * 流量回归机器自动加入一些特殊的配置, 以达到不注册到eureka的目的
 */
public class FlowReplayEnvironmentPostProcessor implements EnvironmentPostProcessor {

	@VisibleForTesting
	public static final String DUIBA_BOOT_FLOW_REPLAY_CONFIG = "duibaBootFlowReplayConfig";

	@Override
	public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
		if(!application.isWebEnvironment()){//判断到是bootstrap的application则跳过
			return;
		}

		if(!FlowReplayUtils.isReplayEnv()){
			return;
		}

		Map<String, Object> properties = new HashMap<>();
		//流量回归机器不注册到eureka
		properties.put("eureka.client.register-with-eureka", "false");

		PropertySource<?> propertySource = new MapPropertySource(DUIBA_BOOT_FLOW_REPLAY_CONFIG,
				properties);
		//优先级最高
		environment.getPropertySources().addFirst(propertySource);
	}
}
