package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;

/**
 * 流量回归开始
 * Created by guoyanfei .
 * 2019-02-19 .
 */
@Slf4j
public class ReplayMvcEndpoint extends AbstractNamedMvcEndpoint {

    public ReplayMvcEndpoint() {
        super("flow/replay", "/flow/replay", true);
    }

    @ResponseBody
    @RequestMapping(method = RequestMethod.POST)
    public String invoke(@RequestBody ReplayConfigDto replayConfig) throws IOException {
        JsonResult<String> result;
        try {
            if (!FlowReplayUtils.isReplayEnv()) {
                throw new FlowReplayException("当前服务非回归专用服务，无法进行回归相关操作");
            }
            // TODO 以下代码暂时注释掉，等测试稳定之后再放开，不然测试麻烦
//            if (!FlowReplayUtils.isReportIdValid(replayConfig.getReportId())) {
//                throw new FlowReplayException("回归报告ID不合法");
//            }
            ReplayContextHolder.start(replayConfig);
            result = JsonResult.successResult(ReplayContextHolder.debugInfo());
        } catch (FlowReplayException e) {
            result = JsonResult.failedResult(e.getMessage());
        } catch (Exception e) {
            log.error("回归start异常", e);
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }

}
