package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.KryoSerializer;
import com.alibaba.fastjson.JSON;
import com.google.gson.JsonElement;

/**
 * 自定义的callback span类型。
 * Created by guoyanfei .
 * 2019-05-23 .
 */
public class CustomizeCallbackFlowReplaySpan extends FlowReplaySpan {

    private static final long serialVersionUID = -3774294652846729094L;

    /**
     * span的标志key
     */
    private String key;

    /**
     * 返回值类型
     */
    private String returnType;

    /**
     * 返回值
     */
    private byte[] returnValue;

    /**
     * 返回值的json值
     */
    private Object returnValueJson;

    @Override
    public SpanType getSpanType() {
        return SpanType.CUSTOMIZE;
    }

    @Override
    public void convertToDetail(String stackFrames) {
        super.convertToDetail(stackFrames);

        JsonElement rTemp = gson.toJsonTree(this.getReturnValue());
        this.returnValueJson = JSON.parse(rTemp.toString());

        this.returnValue = null;
    }

    /**
     * 创建span
     * @param key
     * @param ret
     * @return
     */
    public static CustomizeCallbackFlowReplaySpan createSpan(String key, Object ret) {
        CustomizeCallbackFlowReplaySpan span = new CustomizeCallbackFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.key = key;
        span.setRet(ret);
        return span;
    }

    public void setRet(Object ret) {
        this.returnType = (ret != null ? ret.getClass().getName() : null);
        this.returnValue = KryoSerializer.serialize(ret);
    }

    public String getKey() {
        return key;
    }

    public String getReturnType() {
        return returnType;
    }

    public Object getReturnValue() {
        return KryoSerializer.deserialize(returnValue);
    }

    public Object getReturnValueJson() {
        return returnValueJson;
    }
}
