package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;

import java.lang.reflect.Method;

/**
 * 随机数类型的span
 * Created by guoyanfei .
 * 2019-05-17 .
 */
public class RandomFlowReplaySpan extends StandardSpan {

    private static final long serialVersionUID = 5055163395267674847L;

    @Override
    public SpanType getSpanType() {
        return SpanType.RANDOM;
    }

    /**
     * 创建span
     * @param method
     * @param allArguments
     * @param argumentsTypes
     * @param ret
     * @return
     */
    public static RandomFlowReplaySpan createSpan(Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        String[] parameterTypes = null;
        if (argumentsTypes.length > 0) {
            parameterTypes = new String[argumentsTypes.length];
            for (int i = 0; i < argumentsTypes.length; i++) {
                parameterTypes[i] = argumentsTypes[i].getName();
            }
        }
        RandomFlowReplaySpan span = new RandomFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.setMethodName(method.getName());
        span.setParameterTypes(parameterTypes);
        span.setParameterValues(allArguments);
        span.setReturnType(method.getReturnType().getName());
        if (ret != null) {
            span.setReturnValue(ret);
        }
        return span;
    }

}
