package cn.com.duibaboot.ext.autoconfigure.httpclient.ssre;

import cn.com.duiba.boot.utils.NetUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;

class SsreUtils {

    private static Logger logger = LoggerFactory.getLogger(SsreHttpClientWrapper.class);

    static void checkSsre(HttpHost target){
        if(target==null){
            return;
        }
        List<InetAddress> addreses = Collections.emptyList();
        try{
            addreses = Lists.newArrayList(InetAddress.getAllByName(target.getHostName()));
        }catch (Exception e){
            logger.debug("域名解析失败",e);
        }
        for(InetAddress address:addreses){
            checkSsre(address.getHostAddress());
        }

    }

    static void checkSsre(URI uri){
        if(uri==null){
            return;
        }
        List<InetAddress> addreses = Collections.emptyList();
        try{
            addreses = Lists.newArrayList(InetAddress.getAllByName(uri.getHost()));
        }catch (Exception e){
            logger.debug("域名解析失败",e);
        }
        for(InetAddress address:addreses){
            checkSsre(address.getHostAddress());
        }
    }

    static void checkSsre(String ip){
        if(StringUtils.isBlank(ip)){
            return;
        }
        if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0") || NetUtils.isLanIp(ip)) {//NOSONAR
            throw new SsreRiskException("SSRE风险，HttpClient不能用于访问内网");
        }
    }


}
