package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

/**
 * dubbo压测Filter，用于设置压测标记.
 * Created by wenqi.huang on 2016/11/24.
 */
@Activate(group={"consumer","provider"},order = 0)
public class DubboPerfTestFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        String sideKey = url.getParameter("side");
        boolean isConsumerSide = "consumer".equals(sideKey);
        boolean isProviderSide = "provider".equals(sideKey);

        RpcContext context = RpcContext.getContext();
        //不能使用context.isConsumerSide()/context.isProviderSide()，在嵌套dubbo调用的时候会改变。。坑
        if(isConsumerSide) {
            if (InternalPerfTestContext.isCurrentInPerfTestMode()) {//表示线上压测流量
                boolean isPerfTestSupportted = invoker.getUrl().getParameter(DubboPerfTestRegistryFactoryWrapper.IS_PERF_TEST_SUPPORTTED_KEY, false);
                if(!isPerfTestSupportted){
                    throw new RpcException("dubbo invoker:"+invoker.getUrl().toServiceString()+"，识别到当前请求是压测流量，但是对应的服务不支持性能压测，放弃本次请求，请通知该服务负责人加入spring-boot-starter-perftest依赖");
                }
                context.setAttachment(PerfTestUtils.IS_PERF_TEST_MODE_HEADER_KEY, "true");//这个标记在dubbo请求完毕后会自动清空
                context.setAttachment(PerfTestUtils.PERF_TEST_SCENE_ID_KEY, InternalPerfTestContext.getCurrentSceneId());
                context.setAttachment(PerfTestUtils.PERF_TEST_CLUSTER, String.valueOf(InternalPerfTestContext.isTestCluster()));
            }
        }else{
            String val = context.getAttachment(PerfTestUtils.IS_PERF_TEST_MODE_HEADER_KEY);
            if("true".equals(val)){
                String perfTestSceneId = context.getAttachment(PerfTestUtils.PERF_TEST_SCENE_ID_KEY);
                boolean isTestCluster = Boolean.valueOf(context.getAttachment(PerfTestUtils.PERF_TEST_CLUSTER));
                InternalPerfTestContext.markAsPerfTest(perfTestSceneId, isTestCluster);
            }
        }

        Result result;
        try {
            result = invoker.invoke(invocation);
        }finally {
            if(isProviderSide) {
                InternalPerfTestContext.markAsNormal();
            }
        }
        return result;
    }
}
