package cn.com.duibaboot.ext.autoconfigure.profiler;

import cn.com.duiba.wolf.dubbo.InitOperation;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 * 自动配置DBTimeProfiler,自动给注解了@DBTimeProfiler的方法增加耗时监控，超时的时候打印超时WARN日志.
 */
@Configuration
@EnableAspectJAutoProxy(proxyTargetClass = true)
@ConditionalOnClass(DBTimeProfile.class)
@EnableConfigurationProperties(TimeProfileProperties.class)
public class TimeProfilerAutoConfiguration {

    @Resource
    private TimeProfileProperties timeProfileProperties;

    @Bean
    public TimeProfileAspect timeProfileAspect(){
        return new TimeProfileAspect();
    }

    @PostConstruct
    public void init(){
        InitOperation.init();//确保这个被调用了。

        changeTimeProfileThreshold();
    }

    @EventListener(EnvironmentChangeEvent.class)
    @Order(Ordered.LOWEST_PRECEDENCE)
    public void changeTimeProfileThreshold(){
        Integer threshold = timeProfileProperties.getThreshold();
        if(threshold != null) {
            DBTimeProfile.setThreshold(threshold);
        }
    }
}
