package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.google.common.base.Throwables;
import org.apache.rocketmq.client.consumer.listener.*;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.factory.BeanNameAware;

import java.util.List;

/**
 * RocketMQ MessageListener的包装，增加cat监控
 */
public class MessageListenerOrderlyWrapper implements MessageListenerOrderly, BeanNameAware {

    private MessageListenerOrderly source;

    private String beanName;
    private RocketMqProperties.ConsumerProperties consumerProperties;

    public MessageListenerOrderlyWrapper(MessageListenerOrderly source, String beanName){
        this.source = source;
        this.beanName = beanName;
    }

    @Override
    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
        DBTimeProfile.start();
        try {
            return CatUtils.executeInCatTransaction(() -> source.consumeMessage(msgs, context),
                    "MessageQueue", "RocketMQ.consume");
        } catch(Throwable e) {
            throw Throwables.propagate(e);
        } finally {
            DBTimeProfile.end("RocketMQ.consume");
        }
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return beanName;
    }

    public RocketMqProperties.ConsumerProperties getConsumerProperties() {
        return consumerProperties;
    }

    public void setConsumerProperties(RocketMqProperties.ConsumerProperties consumerProperties) {
        this.consumerProperties = consumerProperties;
    }
}
