package cn.com.duibaboot.ext.autoconfigure.security;

import cn.com.duibaboot.ext.autoconfigure.security.exception.DuibaSecurityException;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.BodyReaderHttpServletRequestWrapper;
import org.springframework.http.MediaType;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Set;


/**
 * 防御策略
 */
public interface DefensivePolicy {

    /**
     * 指定对何种媒体类型做出防御行为
     */
    Set<MediaType> getMediaTypes();

    /**
     * 预处理请求
     * @param request 请求
     **/
    default HttpServletRequest preprocessorRequest(HttpServletRequest request){
        return request;
    }

    /**
     * 预处理响应
     * @param response 响应
     **/
    default HttpServletResponse preprocessorResponse(HttpServletResponse response){
        return response;
    }

    /**
     * 执行防御检测
     * @throws DuibaSecurityException 触发安全防御规则
     */
    void doDefensive(HttpServletRequest request, HttpServletResponse response) throws DuibaSecurityException;


}
