/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.exception.IllegalPluginDefineException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PluginCfg {
    INSTANCE;

    private final Logger logger = LoggerFactory.getLogger((String)PluginCfg.class.getName());
    private List<PluginDefine> pluginClassList = new ArrayList<PluginDefine>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(InputStream input) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String pluginDefine;
            while ((pluginDefine = reader.readLine()) != null) {
                try {
                    if (pluginDefine.trim().length() == 0) continue;
                    PluginDefine plugin = PluginDefine.build(pluginDefine);
                    this.pluginClassList.add(plugin);
                }
                catch (IllegalPluginDefineException e) {
                    this.logger.error(String.format("Failed to format plugin(%s) define.", pluginDefine), (Throwable)e);
                }
            }
        }
        finally {
            input.close();
        }
    }

    public List<PluginDefine> getPluginClassList() {
        return this.pluginClassList;
    }
}

