/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.StaticMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.loader.InterceptorInstanceLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMethodsInter {
    private static final Logger logger = LoggerFactory.getLogger(StaticMethodsInter.class);
    private List<StaticMethodsAroundInterceptor> interceptors = new ArrayList<StaticMethodsAroundInterceptor>();

    public StaticMethodsInter(String staticMethodsAroundInterceptorClassName, ClassLoader classLoader) {
        try {
            String[] classNames;
            for (String className : classNames = staticMethodsAroundInterceptorClassName.split(",")) {
                StaticMethodsAroundInterceptor interceptor = (StaticMethodsAroundInterceptor)InterceptorInstanceLoader.load(className, classLoader);
                this.interceptors.add(interceptor);
            }
        }
        catch (Throwable t) {
            throw new PluginException("Can't create StaticMethodsAroundInterceptor.", t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public Object intercept(@Origin Class<?> clazz, @AllArguments Object[] allArguments, @Origin Method method, @SuperCall Callable<?> zuper) throws Throwable {
        MethodInterceptResult result = new MethodInterceptResult();
        try {
            for (StaticMethodsAroundInterceptor interceptor : this.interceptors) {
                interceptor.beforeMethod(clazz, method, allArguments, method.getParameterTypes(), result);
            }
        }
        catch (PluginException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.error("class[{}] before static method[{}] intercept failure", new Object[]{clazz, method.getName(), t});
        }
        Object ret = null;
        try {
            ret = !result.isContinue() ? result._ret() : zuper.call();
        }
        catch (Throwable t) {
            try {
                try {
                    int i = this.interceptors.size() - 1;
                    while (i >= 0) {
                        StaticMethodsAroundInterceptor interceptor = this.interceptors.get(i);
                        interceptor.handleMethodException(clazz, method, allArguments, method.getParameterTypes(), t);
                        --i;
                    }
                    throw t;
                }
                catch (PluginException e) {
                    throw e;
                }
                catch (Throwable t2) {
                    logger.error("class[{}] handle static method[{}] exception failure", new Object[]{clazz, method.getName(), t2});
                }
                throw t;
            }
            catch (Throwable throwable) {
                try {
                    int i = this.interceptors.size() - 1;
                    while (i >= 0) {
                        StaticMethodsAroundInterceptor interceptor = this.interceptors.get(i);
                        ret = interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret);
                        --i;
                    }
                    throw throwable;
                }
                catch (PluginException e) {
                    throw e;
                }
                catch (Throwable t2) {
                    logger.error("class[{}] after static method[{}] intercept failure:{}", new Object[]{clazz, method.getName(), t2});
                }
                throw throwable;
            }
        }
        try {
            int i = this.interceptors.size() - 1;
            while (i >= 0) {
                StaticMethodsAroundInterceptor interceptor = this.interceptors.get(i);
                ret = interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret);
                --i;
            }
            return ret;
        }
        catch (PluginException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.error("class[{}] after static method[{}] intercept failure:{}", new Object[]{clazz, method.getName(), t});
            return ret;
        }
    }
}

