/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.limiter;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duibaboot.ext.autoconfigure.etcd.EtcdAutoConfiguration;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.limiter.ServerLimiterDo;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.RateLimiter;
import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.limit.VegasLimit;
import com.netflix.concurrency.limits.limiter.SimpleLimiter;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
@AutoConfigureAfter(value={EtcdAutoConfiguration.class})
public class ServerLimiterAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ServerLimiterAutoConfiguration.class);
    @Value(value="${spring.application.name}")
    private String currentAppName;
    @Resource
    private EtcdKVClientDelegate etcdKVClientDelegate;
    private static final Map<String, Object> serverLimitRuleMap = Maps.newConcurrentMap();

    public static Object getServerLimitRule(String server) {
        return serverLimitRuleMap.get(server);
    }

    @EventListener(value={MainContextRefreshedEvent.class})
    public void initLimitRule() {
        this.loadLimiterRule();
    }

    @EventListener(value={EnvironmentChangeEvent.class})
    public void listenLimitRule() {
        this.loadLimiterRule();
    }

    private void loadLimiterRule() {
        if (StringUtils.isBlank((CharSequence)this.currentAppName)) {
            log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u5f53\u524d\u5e94\u7528\u7684\u540d\u79f0\uff0c\u9650\u6d41\u521d\u59cb\u5316\u5931\u8d25");
            return;
        }
        Map<String, String> appLimiterMap = this.etcdKVClientDelegate.getWithPrefix(String.format("/config/%s/server.limit.rule", this.currentAppName));
        if (appLimiterMap == null) {
            return;
        }
        for (Map.Entry<String, String> entry : appLimiterMap.entrySet()) {
            List splitters = Splitter.on((String)"/").splitToList((CharSequence)entry.getKey());
            ServerLimiterDo serverLimiterDo = (ServerLimiterDo)JSON.parseObject((String)entry.getValue(), ServerLimiterDo.class);
            serverLimitRuleMap.put((String)splitters.get(4), this.buildLimiter(serverLimiterDo));
        }
    }

    private Object buildLimiter(ServerLimiterDo serverLimiterDo) {
        if (serverLimiterDo.getLimitType() == 0) {
            return RateLimiter.create((double)serverLimiterDo.getLimitValue().longValue());
        }
        VegasLimit limit = VegasLimit.newDefault();
        return ((SimpleLimiter.Builder)SimpleLimiter.newBuilder().limit((Limit)limit)).build();
    }
}

