/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheChangeRecord;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorManager;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.RecordPagerResponse;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public class CacheMonitorMvcEndpoint
extends AbstractNamedMvcEndpoint {
    public CacheMonitorMvcEndpoint() {
        super("monitor/cache", "/monitor/cache", true);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"}, value={"/{path}"})
    public Object invoke(@PathVariable String path, HttpServletRequest request) {
        if (path.equals("all")) {
            return CacheMonitorManager.getAllCache();
        }
        if (path.equals("query")) {
            return this.doQuery((ServletRequest)request);
        }
        if (path.equals("record")) {
            return this.doRecord((ServletRequest)request);
        }
        return "";
    }

    private Object doQuery(ServletRequest servletRequest) {
        String key = servletRequest.getParameter("key");
        String cacheName = servletRequest.getParameter("cacheName");
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)cacheName)) {
            return "";
        }
        return CacheMonitorManager.getCacheValueByKey(cacheName, key);
    }

    private Object doRecord(ServletRequest servletRequest) {
        RecordPagerResponse<CacheChangeRecord> records;
        String key = servletRequest.getParameter("key");
        String cacheName = servletRequest.getParameter("cacheName");
        String page = servletRequest.getParameter("page");
        if (StringUtils.isBlank((CharSequence)page)) {
            page = "1";
        }
        if ((records = CacheMonitorManager.getRecord(cacheName, key, Integer.parseInt(page))) == null) {
            return "";
        }
        return records;
    }
}

