/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ScheduledThreadPoolExecutorWrapper;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import com.alibaba.ttl.TtlRunnable;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.lang.reflect.Field;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.BeansException;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.ReflectionUtils;

public class TransmittableExecutorBeanPostProcessor
implements SpecifiedBeanPostProcessor<Executor> {
    @Override
    public Class<Executor> getBeanType() {
        return Executor.class;
    }

    @Override
    public Object postProcessBeforeInitialization(Executor bean, String beanName) throws BeansException {
        Field field;
        if (bean instanceof TaskExecutor && (field = ReflectionUtils.findField(bean.getClass(), (String)"taskDecorator", TaskDecorator.class)) != null) {
            field.setAccessible(true);
            TaskDecorator taskDecorator = (TaskDecorator)ReflectionUtils.getField((Field)field, (Object)bean);
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)new TtlTaskDecorator(taskDecorator));
        }
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Executor bean, String beanName) throws BeansException {
        if (bean instanceof TaskExecutor) {
            return bean;
        }
        if (bean instanceof ScheduledThreadPoolExecutorWrapper || bean instanceof ThreadPoolExecutorWrapper) {
            return bean;
        }
        if (bean instanceof ScheduledExecutorService) {
            bean = TtlExecutors.getTtlScheduledExecutorService((ScheduledExecutorService)((ScheduledExecutorService)bean));
        } else if (bean instanceof ExecutorService) {
            bean = TtlExecutors.getTtlExecutorService((ExecutorService)((ExecutorService)bean));
        } else if (bean instanceof Executor) {
            bean = TtlExecutors.getTtlExecutor((Executor)bean);
        }
        return bean;
    }

    public int getOrder() {
        return 0;
    }

    private static class TtlTaskDecorator
    implements TaskDecorator {
        private TaskDecorator original;

        public TtlTaskDecorator(TaskDecorator original) {
            this.original = original;
        }

        public Runnable decorate(Runnable runnable) {
            if (this.original == null) {
                return TtlRunnable.get((Runnable)runnable);
            }
            return TtlRunnable.get((Runnable)this.original.decorate(runnable));
        }
    }
}

