/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceRunnable;

public class MonitorRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MonitorRunnable.class);
    private static final boolean IS_SLEUTH_CLASS_EXISTS;
    private Runnable runnable;
    private BlockingQueue<Runnable> queue;
    private final int maxWaitTimeMillis;
    private final long submitTimeMillis;

    public MonitorRunnable(Runnable runnable) {
        this(runnable, null);
    }

    public MonitorRunnable(Runnable runnable, BlockingQueue<Runnable> queue) {
        this(runnable, queue, 1000);
    }

    public MonitorRunnable(Runnable runnable, BlockingQueue<Runnable> queue, int maxWaitTimeMillis) {
        this.runnable = runnable;
        this.queue = queue;
        this.submitTimeMillis = System.currentTimeMillis();
        this.maxWaitTimeMillis = maxWaitTimeMillis;
    }

    public long getSubmitTimeMillis() {
        return this.submitTimeMillis;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    @Override
    public void run() {
        long waitTimeMillis = System.currentTimeMillis() - this.submitTimeMillis;
        if (waitTimeMillis >= (long)this.maxWaitTimeMillis) {
            if (this.queue == null) {
                logger.warn("RunnableClass:{}, ThreadName:{} wait {} ms in queue, maybe corePoolSize is too small.", new Object[]{this.getRootRunnable().getClass().getName(), Thread.currentThread().getName(), waitTimeMillis});
            } else {
                logger.warn("RunnableClass:{}, ThreadName:{} wait {} ms in queue(queueSize:{}), maybe corePoolSize is too small.", new Object[]{this.getRootRunnable().getClass().getName(), Thread.currentThread().getName(), waitTimeMillis, this.queue.size()});
            }
        }
        this.runnable.run();
    }

    protected Runnable getRootRunnable() {
        Runnable rootRunnable = this.getRunnable();
        if (IS_SLEUTH_CLASS_EXISTS && rootRunnable instanceof SpanContinuingTraceRunnable) {
            rootRunnable = ((SpanContinuingTraceRunnable)rootRunnable).getDelegate();
        }
        return rootRunnable;
    }

    static {
        boolean isSleuthClassExists = false;
        try {
            Class.forName("org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceRunnable");
            isSleuthClassExists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_SLEUTH_CLASS_EXISTS = isSleuthClassExists;
    }
}

