package cn.com.duibaboot.ext.autoconfigure.elasticjob;

import com.dangdang.ddframe.job.spring.schedule.SpringJobScheduler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

/**
 * 修复elasticjob与spring-cloud不兼容的问题，elasticjob过早调用了feign，报出超时问题，这里尝试延迟到容器启动完成后再执行任务
 */
@Configuration
public class ElasticJobFixAutoConfiguration {

    /**
     * elastic job 1.*
     */
    @Configuration
    @ConditionalOnClass(SpringJobScheduler.class)
    public static class ElasticJob1Configuration {

        @EventListener(EmbeddedServletContainerInitializedEvent.class)
        public void onEvent(EmbeddedServletContainerInitializedEvent event){
            DelayedThreadExecutor.startAllTaskThreads();
        }
    }

    @Bean("elasticJobMonitorEndpoint")
	@ConditionalOnClass(name="io.elasticjob.lite.internal.schedule.JobRegistry")
	@ConditionalOnMissingBean(name="elasticJobMonitorEndpoint")
    public ElasticJobMonitorEndpointV3 elasticJobMonitorEndpointV3(){
        return new ElasticJobMonitorEndpointV3();
    }

	@Bean("elasticJobMonitorEndpoint")
	@ConditionalOnClass(name="com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry")
	@ConditionalOnMissingBean(name="elasticJobMonitorEndpoint")
    public ElasticJobMonitorEndpointV2 elasticJobMonitorEndpointV2(){
        return new ElasticJobMonitorEndpointV2();
    }

}
