package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by guoyanfei .
 * 2019-09-20 .
 */
public class RecordDetailContext {

    /**
     * 堆栈节点的前缀白名单
     * 每个span都有自己的调用链堆栈，其中很多内容是开发不需要关心的。
     * 一般情况下，开发关心的都是公司内部的一些包下面的调用
     * 比如 cn.com.duiba / cn.tuia 等等开头的行
     * 这个白名单的功能就是维护了公司内部的一些包的开头，用来过滤出开发需要关心的堆栈
     */
    private final List<String> stackFramesPrefixWhitelist;

    /**
     * key: traceId
     * subKey: spanId
     * value: 被 @stackFramesPrefixWhitelist 过滤后的 stacktrace
     */
    private final Map<String, Map<String, String>> traceSpanStackFramesMap;

    public RecordDetailContext(List<String> stackFramesPrefixWhitelist) {
        this.stackFramesPrefixWhitelist = stackFramesPrefixWhitelist;
        this.traceSpanStackFramesMap = new ConcurrentHashMap<>();
    }

    /**
     * 把在每个span创建之后，都设置一下堆栈
     * 最后生成录制详情的时候需要拿出来设置到详情中
     * @param traceId
     * @param spanId
     */
    public void setSpanStackTrace(FlowReplaySpan span) {
        String[] stackFrames = ExceptionUtils.getStackFrames(new Exception());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stackFrames.length; i++) {
            if (i == 0) {
                continue;
            }
            String frame = stackFrames[i];
            if (i < 6 || isPrefixWhitelistStackFrame(frame)) {
                sb.append(frame).append("\n");
            }
        }
        Map<String, String> spanStackFramesMap = traceSpanStackFramesMap.computeIfAbsent(span.getTraceId(), k -> new ConcurrentHashMap<>());
        spanStackFramesMap.computeIfAbsent(span.getSpanId(), k -> sb.toString());
    }

    public Map<String, String> getAndRemoveTraceSpanStackFrames(String traceId) {
        Map<String, String> spanStackFramesMap = traceSpanStackFramesMap.get(traceId);
        traceSpanStackFramesMap.remove(traceId);
        return spanStackFramesMap != null ? spanStackFramesMap : Collections.emptyMap();
    }

    /**
     * 判断堆栈一行的前缀是不是白名单内的
     * @param frame
     * @return
     */
    private boolean isPrefixWhitelistStackFrame(String frame) {
        // 具体的异常行，都要
        if (!frame.startsWith("\tat ")) {
            return true;
        }
        if (CollectionUtils.isEmpty(stackFramesPrefixWhitelist)) {
            return false;
        }
        for (String prefix : stackFramesPrefixWhitelist) {
            if (frame.contains(prefix)) {
                return true;
            }
        }
        return false;
    }
}
