package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.RemoteServiceFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.RecordSampler;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

import javax.annotation.Resource;

/**
 * remoteService流量录制的aop
 */
@Slf4j
@Aspect
public class RecordRemoteServicePlugin {

    @Resource
    private RecordSampler recordSampler;

    @Around("execution(* *..Remote*ServiceImpl.*(..))")
    public Object remoteServiceJoinPoint(ProceedingJoinPoint point) throws Throwable {
        RemoteServiceFlowReplaySpan mainSpan = null;
        Object returnValue = null;
        try {
            mainSpan = this.tryTrace(point);
        } catch (Throwable t) {
            log.error("RecordRemoteService_tryTrace_error", t);
        }
        try {
            // 执行方法并获取返回值
            returnValue = point.proceed();
        } finally {
            this.tryStoreTrace(mainSpan, returnValue);
        }
        return returnValue;
    }

    /**
     * 请求尝试追踪
     * @param point
     * @return
     */
    private RemoteServiceFlowReplaySpan tryTrace(ProceedingJoinPoint point) {
        RemoteServiceFlowReplaySpan mainSpan = null;
        // 录制开关开启，并且本次需要采样
        if (RecordContextHolder.isRecording() && recordSampler.isSampled()) {
            MethodSignature methodSignature = (MethodSignature) point.getSignature();
            Object[] parameterValues = point.getArgs();

            FlowReplayTrace.cleanRecordEnv();

            mainSpan = RemoteServiceFlowReplaySpan.createSpan(methodSignature, parameterValues);
            FlowReplayTrace.createTrace(mainSpan);
            mainSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());

            IgnoreSubInvokesContext.unmark();
        }
        return mainSpan;
    }

    /**
     * 持久化trace
     * @param mainSpan
     * @param returnValue
     */
    private void tryStoreTrace(RemoteServiceFlowReplaySpan mainSpan, Object returnValue) {
        RecordContext context = RecordContextHolder.getRecordContext();
        if (context == null || mainSpan == null) {
            return;
        }
        try {
            mainSpan.setReturnValue(returnValue);
            FlowReplayTrace trace = FlowReplayTrace.get();
            if (trace != null) {
                context.offerTrace(trace);
            }
        } catch (Throwable t) {
            log.error("RecordRemoteServicePlugin_tryStoreTrace_error", t);
        } finally {
            FlowReplayTrace.remove();
        }
    }
}
