package cn.com.duibaboot.ext.autoconfigure.javaagent.common;


import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

import static cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch.byName;
import static net.bytebuddy.matcher.ElementMatchers.named;

public class JedisBinaryClientInstrumentation extends ClassInstanceMethodsEnhancePluginDefine implements AgentPluginExtSpi {

    private static final String ENHANCE_CLASS = "redis.clients.jedis.BinaryClient";

    @Override
    public ClassMatch enhanceClass() {
        return byName(ENHANCE_CLASS);
    }

    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return new ConstructorInterceptPoint[0];
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[] {
            new InstanceMethodsInterceptPoint() {
                @Override
                public ElementMatcher<MethodDescription> getMethodsMatcher() {
                    //此处的方法需要为所有MethodsInterceptor的超集，然后在每个MethodsInterceptor内部判断只处理自己需要的方法
                    return named("connect")
                            .or(named("disconnect"))
                            .or(named("isConnected"))
                            .or(named("getStatusCodeReply"))
                            .or(named("close"))
                            .or(named("ping"))
                            .or(named("auth"));
                }

                @Override
                public String getMethodsInterceptor() {
                    return getInterceptorClassNames("jedis-binary-client-interceptor");
                }

                @Override public boolean isOverrideArgs() {
                    //如果任意一个MethodsInterceptor需要修改参数，则此处需要为true
                    return true;
                }
            }
        };
    }
}
