/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record;

import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordStartEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.Hessian2Serializer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class RecordTraceWriter {
    private static final Logger log = LoggerFactory.getLogger(RecordTraceWriter.class);
    private volatile Thread traceWriteThread;

    @EventListener(value={RecordStartEvent.class})
    public void recordStartEventListener(RecordStartEvent event) {
        this.traceWriteThread = new Thread(new TraceWriteThread(RecordContextHolder.getRecordContext()));
        this.traceWriteThread.start();
    }

    @EventListener(value={RecordEndEvent.class})
    public void recordEndEventListener() {
        if (this.traceWriteThread != null) {
            this.traceWriteThread.interrupt();
        }
    }

    private static class TraceWriteThread
    implements Runnable {
        private RecordContext context;

        private TraceWriteThread(RecordContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                this.writeTrace();
            }
            catch (Exception e) {
                log.error("writeTrace\u5f02\u5e38", (Throwable)e);
                RecordContextHolder.abnormalEnd("writeTrace\u5f02\u5e38:" + e.getMessage());
            }
        }

        private void writeTrace() throws IOException {
            File recordLocalFile = new File("/data/flowreplay/flow_record");
            File recordDetailLocalFile = new File("/data/flowreplay/flow_record_detail");
            try (RandomAccessFile recordRaf = new RandomAccessFile(recordLocalFile, "rw");
                 RandomAccessFile recordDetailRaf = new RandomAccessFile(recordDetailLocalFile, "rw");){
                int expectFileSize = this.context.getMaxFileSize() * 1024 * 1024;
                recordRaf.writeInt(1);
                recordRaf.writeInt(0);
                recordDetailRaf.writeInt(1);
                recordDetailRaf.writeInt(0);
                recordDetailRaf.writeLong(0L);
                ArrayList<Pair> traceIdIndexList = new ArrayList<Pair>();
                int usecaseCount = 0;
                while (!this.context.isRecordFinished()) {
                    if (this.context.isTimeToEnd()) {
                        RecordContextHolder.normalEnd();
                        continue;
                    }
                    try {
                        FlowReplayTrace trace = this.context.pollTrace();
                        if (trace == null) continue;
                        ++usecaseCount;
                        byte[] traceBytes = Hessian2Serializer.serialize(trace);
                        recordRaf.writeInt(traceBytes.length);
                        recordRaf.write(traceBytes);
                        Map<String, String> spanStackFramesMap = this.context.getRecordDetailContext().getAndRemoveTraceSpanStackFrames(trace.getTraceId());
                        trace.convertToDetail(spanStackFramesMap);
                        byte[] traceDetailBytes = Hessian2Serializer.serialize(trace);
                        traceIdIndexList.add(Pair.from((Object)trace.getTraceId(), (Object)recordDetailRaf.getFilePointer()));
                        recordDetailRaf.writeInt(traceDetailBytes.length);
                        recordDetailRaf.write(traceDetailBytes);
                        this.context.setCurrentFileSize(recordRaf.getFilePointer());
                        if ((long)expectFileSize < this.context.getCurrentFileSize()) {
                            RecordContextHolder.normalEnd();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        log.error("\u5355\u4e2a\u7528\u4f8b\u5199\u5165\u5f02\u5e38", (Throwable)e);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                }
                recordRaf.seek(4L);
                recordRaf.writeInt(usecaseCount);
                long idxIndex = recordDetailRaf.getFilePointer();
                for (Pair p : traceIdIndexList) {
                    byte[] traceIdBytes = Hessian2Serializer.serialize(p.getKey());
                    recordDetailRaf.writeInt(traceIdBytes.length);
                    recordDetailRaf.write(traceIdBytes);
                    recordDetailRaf.writeLong((Long)p.getValue());
                }
                recordDetailRaf.seek(4L);
                recordDetailRaf.writeInt(usecaseCount);
                recordDetailRaf.writeLong(idxIndex);
            }
        }
    }
}

