/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.MybatisFlowReplaySpan;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(method="update", type=Executor.class, args={MappedStatement.class, Object.class})})
public class RecordMybatisPlugin
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(RecordMybatisPlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object ret;
        if (!FlowReplayTrace.isTraced()) {
            return invocation.proceed();
        }
        if (IgnoreSubInvokesContext.isMarked()) {
            return invocation.proceed();
        }
        Object target = invocation.getTarget();
        Method method = invocation.getMethod();
        Object[] args = invocation.getArgs();
        IgnoreSubInvokesContext.instMark(target, method.getName(), args);
        MybatisFlowReplaySpan span = null;
        try {
            MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
            Object parameter = invocation.getArgs()[1];
            span = MybatisFlowReplaySpan.createSpan(ms.getId(), parameter);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
        }
        catch (Throwable t) {
            log.error("Mybatis_\u5f55\u5236\u5f02\u5e38", t);
        }
        try {
            ret = invocation.proceed();
        }
        catch (Throwable t) {
            FlowReplayTrace.remove();
            IgnoreSubInvokesContext.unmark();
            throw t;
        }
        try {
            if (span != null) {
                span.setRet(ret);
            }
        }
        catch (Throwable t) {
            log.error("Mybatis_\u5f55\u5236\u5f02\u5e38", t);
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties arg0) {
    }
}

