/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.Hessian2Serializer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ReplayTraceResultWriter {
    private static final Logger log = LoggerFactory.getLogger(ReplayTraceResultWriter.class);
    private volatile Thread traceResultWriteThread;

    @EventListener(value={ReplayStartEvent.class})
    public void replayStartEventListener(ReplayStartEvent event) {
        this.traceResultWriteThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReplayContext context = ReplayContextHolder.getReplayContext();
                if (context == null) {
                    return;
                }
                try {
                    ReplayTraceResultWriter.this.writeTraceResult(context);
                }
                catch (Exception e) {
                    log.error("\u5f15\u6d41\u56de\u5f52_\u56de\u653e\u7ed3\u679c\u5199\u6587\u4ef6\u5f02\u5e38_reportId_{}", (Object)context.getReportId(), (Object)e);
                    ReplayContextHolder.forceEnd();
                }
            }
        }, "DBThread-Replay-\u5199\u56de\u653e\u7ed3\u679c");
        this.traceResultWriteThread.start();
    }

    @EventListener(value={ReplayEndEvent.class})
    public void replayEndEventListener(ReplayEndEvent event) {
        if (this.traceResultWriteThread != null) {
            this.traceResultWriteThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTraceResult(ReplayContext context) throws IOException {
        File localReportFile = new File("/data/flowreplay/replay_result");
        File localReplayDetailFile = new File("/data/flowreplay/flow_replay_detail");
        try (RandomAccessFile reportFile = new RandomAccessFile(localReportFile, "rw");
             RandomAccessFile replayDetailFile = new RandomAccessFile(localReplayDetailFile, "rw");){
            reportFile.writeInt(1);
            reportFile.writeInt(0);
            replayDetailFile.writeInt(1);
            replayDetailFile.writeInt(0);
            replayDetailFile.writeLong(0L);
            ArrayList<Pair> traceIdIndexList = new ArrayList<Pair>();
            int usecaseCount = 0;
            while (!context.isReplayersDone() || !context.isResultQueueEmpty()) {
                ReplayTraceResult result = null;
                try {
                    result = context.pollResult();
                    if (result == null) continue;
                    byte[] resultBytes = Hessian2Serializer.serialize(result);
                    reportFile.writeInt(resultBytes.length);
                    reportFile.write(resultBytes);
                    FlowReplayTrace detailTrace = result.getReplayDetailTrace();
                    if (detailTrace != null) {
                        ++usecaseCount;
                        Map<String, String> spanStackFramesMap = ReplayContextHolder.getReplayContext().getReplayDetailContext().getAndRemoveTraceSpanStackFrames(detailTrace.getTraceId());
                        detailTrace.convertToDetail(spanStackFramesMap);
                        byte[] traceDetailBytes = Hessian2Serializer.serialize(detailTrace);
                        traceIdIndexList.add(Pair.from((Object)detailTrace.getTraceId(), (Object)replayDetailFile.getFilePointer()));
                        replayDetailFile.writeInt(traceDetailBytes.length);
                        replayDetailFile.write(traceDetailBytes);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    log.error("\u56de\u5f52\u7ed3\u679c\u64cd\u4f5c\u5f02\u5e38_traceId={}", (Object)(result != null ? result.getTraceId() : "unknown"), (Object)e);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
            long idxIndex = replayDetailFile.getFilePointer();
            for (Pair p : traceIdIndexList) {
                byte[] traceIdBytes = Hessian2Serializer.serialize(p.getKey());
                replayDetailFile.writeInt(traceIdBytes.length);
                replayDetailFile.write(traceIdBytes);
                replayDetailFile.writeLong((Long)p.getValue());
            }
            replayDetailFile.seek(4L);
            replayDetailFile.writeInt(usecaseCount);
            replayDetailFile.writeLong(idxIndex);
        }
        finally {
            ReplayContextHolder.end();
        }
    }
}

