/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.MybatisFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import java.util.Objects;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import shaded.com.esotericsoftware.kryo.KryoException;

@Intercepts(value={@Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(method="update", type=Executor.class, args={MappedStatement.class, Object.class})})
public class ReplayMybatisPlugin
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        String replayParameterType;
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return invocation.proceed();
        }
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        Object parameter = invocation.getArgs()[1];
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        MybatisFlowReplaySpan replayDetailSpan = this.createReplayDetailSpan(ms.getId(), parameter, span);
        if (span == null || SpanType.MYBATIS != span.getSpanType()) {
            String expert = SpanType.MYBATIS.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        MybatisFlowReplaySpan mybatisSpan = (MybatisFlowReplaySpan)span;
        if (!mybatisSpan.getMappedStatementId().equals(ms.getId())) {
            String expert = mybatisSpan.getMappedStatementId();
            String actual = ms.getId();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1021, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        String recordParameterType = mybatisSpan.getParameterType();
        String string = replayParameterType = parameter != null ? parameter.getClass().getName() : null;
        if (!Objects.equals(recordParameterType, replayParameterType)) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1022, recordParameterType, replayParameterType);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            if (!FlowReplayUtils.isObjectEqual(mybatisSpan.getParameterValue(), parameter)) {
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1023);
                throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
            }
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1025, e);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            Object mockRet = mybatisSpan.getReturnValue();
            replayDetailSpan.setRet(mockRet);
            return mockRet;
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1026, e);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }

    private MybatisFlowReplaySpan createReplayDetailSpan(String mappedStatementId, Object parameter, FlowReplaySpan span) {
        MybatisFlowReplaySpan replayDetailSpan = MybatisFlowReplaySpan.createSpan(mappedStatementId, parameter);
        replayDetailSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());
        if (span != null) {
            replayDetailSpan.setSpanId(span.getSpanId());
        }
        FlowReplayTrace.addSubSpan(replayDetailSpan);
        return replayDetailSpan;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties arg0) {
    }
}

