/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.security;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.util.UrlPathHelper;

public class DevEnvSecurityPreprocessor {
    public static final String DEFAULT_SKIP_PATTERN = "/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream";
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private Pattern skipPattern = Pattern.compile("/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream");
    public static final String CSRF_OFF = "csrf_off";

    public void preprocessor(HttpServletRequest request, HttpServletResponse response) {
        String uri = this.urlPathHelper.getPathWithinApplication(request);
        boolean skip = this.skipPattern.matcher(uri).matches();
        if (skip || Boolean.parseBoolean(request.getParameter(CSRF_OFF))) {
            request.setAttribute("CSRF_PASS_MARK", (Object)true);
        }
    }
}

