/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import cn.com.duiba.boot.cat.CatWithArgs;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duibaboot.ext.autoconfigure.cat.context.CatContext;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FeignClientFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.netflix.feign.FeignClientFactoryBean;
import shaded.com.esotericsoftware.kryo.KryoException;

public class CustomFeignClientFactoryBean
extends FeignClientFactoryBean {
    private static final Logger log = LoggerFactory.getLogger(CustomFeignClientFactoryBean.class);
    private String springApplicationName;

    public Object getObject() throws Exception {
        Class classType = super.getObjectType();
        Object feignClient = super.getObject();
        Object proxyInstance = this.proxyInstance(classType, feignClient);
        proxyInstance = FlowReplayUtils.isReplayEnv() ? Proxy.newProxyInstance(proxyInstance.getClass().getClassLoader(), new Class[]{classType}, (InvocationHandler)new FlowReplayFeignClientInvocationHandler(proxyInstance)) : Proxy.newProxyInstance(proxyInstance.getClass().getClassLoader(), new Class[]{classType}, (InvocationHandler)new FlowRecordFeignClientInvocationHandler(proxyInstance));
        return proxyInstance;
    }

    private Object proxyInstance(Class classType, Object feignClient) {
        if (CatUtils.isCatClassExists()) {
            return Proxy.newProxyInstance(classType.getClassLoader(), new Class[]{classType}, (InvocationHandler)new FeignClientInvocationHandlerWithCat(this.springApplicationName, feignClient, this.getName()));
        }
        return Proxy.newProxyInstance(classType.getClassLoader(), new Class[]{classType}, (InvocationHandler)new FeignClientInvocationHandler(this.springApplicationName, feignClient, this.getName()));
    }

    public void setSpringApplicationName(String springApplicationName) {
        this.springApplicationName = springApplicationName;
    }

    @VisibleForTesting
    public static class FeignClientInvocationHandlerWithCat
    extends FeignClientInvocationHandler {
        FeignClientInvocationHandlerWithCat(String springApplicationName, Object original, String serverName) {
            super(springApplicationName, original, serverName);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName) || method.isDefault()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            RpcContext.getContext().setMethod(method);
            RpcContext.getContext().setInvokeArgs(args);
            RpcContext.getContext().setSourceServiceId(this.springApplicationName);
            RpcContext.getContext().setTargetServiceId(this.serverName);
            if (!CatUtils.isCatEnabled()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            return this.invokeWithCatTransaction(method, args);
        }

        private Object invokeWithCatTransaction(Method method, Object[] args) throws Throwable {
            String loggerName = this.resolveLoggerName(method, args);
            Transaction transaction = Cat.newTransaction((String)"PigeonCall", (String)loggerName);
            try {
                CatContext context = new CatContext();
                Cat.logRemoteCallClient((Cat.Context)context);
                this.setAttachment(context, method);
                Object result = this.invokeMethodInner(method, this.original, args);
                transaction.setStatus("0");
                Object object = result;
                return object;
            }
            catch (Throwable e) {
                if (!(e instanceof BizException)) {
                    Cat.logError((Throwable)e);
                    transaction.setStatus(e);
                } else {
                    Event bizExceptionEvent = Cat.newEvent((String)"BizException", (String)String.format("BizException(message:%s,code:%s)(this exception will not trigger hystrix)", e.getMessage(), ((BizException)e).getCode()));
                    this.completeEvent(bizExceptionEvent);
                    transaction.addChild((Message)bizExceptionEvent);
                    transaction.setStatus("0");
                }
                throw e;
            }
            finally {
                Event crossAppEvent = Cat.newEvent((String)"PigeonCall.app", (String)this.springApplicationName);
                Event crossServerEvent = Cat.newEvent((String)"PigeonCall.server", (String)this.serverName);
                this.completeEvent(crossAppEvent);
                this.completeEvent(crossServerEvent);
                transaction.addChild((Message)crossAppEvent);
                transaction.addChild((Message)crossServerEvent);
                CatUtils.completeTransaction(transaction);
            }
        }

        private void completeEvent(Event event) {
            AbstractMessage message = (AbstractMessage)event;
            message.setStatus("0");
            message.setCompleted(true);
        }

        private String resolveLoggerName(Method method, Object[] args) {
            StringBuilder loggerName = new StringBuilder(method.getDeclaringClass().getSimpleName()).append(".").append(method.getName());
            if (method.isAnnotationPresent(CatWithArgs.class)) {
                CatWithArgs catWithArgs = method.getAnnotation(CatWithArgs.class);
                int[] argIndexes = catWithArgs.argIndexes();
                if (argIndexes == null || argIndexes.length == 0 || args == null || args.length == 0) {
                    return loggerName.toString();
                }
                StringBuilder sb = new StringBuilder();
                for (int argIdx : argIndexes) {
                    if (argIdx < 0 || args.length <= argIdx) continue;
                    Object obj = args[argIdx];
                    sb.append(obj == null ? "" : obj.toString()).append(",");
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                    sb.insert(0, "(");
                    sb.append(")");
                }
                loggerName.append((CharSequence)sb);
            }
            return loggerName.toString();
        }

        private void setAttachment(CatContext context, Method method) {
            RpcContext.getContext().setAttachment("_catRootMessageId", context.getProperty("_catRootMessageId"));
            RpcContext.getContext().setAttachment("_catChildMessageId", context.getProperty("_catChildMessageId"));
            RpcContext.getContext().setAttachment("_catParentMessageId", context.getProperty("_catParentMessageId"));
            RpcContext.getContext().setAttachment("X-Rpc-Client", this.springApplicationName);
        }
    }

    @VisibleForTesting
    public static class FeignClientInvocationHandler
    implements InvocationHandler {
        protected final String springApplicationName;
        protected final String serverName;
        protected final Object original;

        FeignClientInvocationHandler(String springApplicationName, Object original, String serverName) {
            this.springApplicationName = springApplicationName;
            this.original = original;
            this.serverName = serverName;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName) || method.isDefault()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            RpcContext.getContext().setMethod(method);
            RpcContext.getContext().setInvokeArgs(args);
            RpcContext.getContext().setSourceServiceId(this.springApplicationName);
            RpcContext.getContext().setTargetServiceId(this.serverName);
            return this.invokeMethodInner(method, this.original, args);
        }

        protected Object invokeMethodInner(Method method, Object target, Object[] args) throws Throwable {
            try {
                return method.invoke(target, args);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if (e instanceof HystrixBadRequestException && e.getCause() != null && e.getCause() instanceof BizException) {
                    e = e.getCause();
                }
                throw e;
            }
        }
    }

    public static class FlowReplayFeignClientInvocationHandler
    extends FlowReplayInvocationHandler {
        FlowReplayFeignClientInvocationHandler(Object original) {
            super(original);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName) || method.isDefault()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            if (FlowReplayUtils.isReplayEnv() && ReplayTraceContext.isReplaying()) {
                FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
                FeignClientFlowReplaySpan replayDetailSpan = this.createReplayDetailSpan(method, args, span);
                if (span == null || SpanType.FEIGN_CLIENT != span.getSpanType()) {
                    String expert = SpanType.FEIGN_CLIENT.name();
                    String actual = span != null ? span.getSpanType().name() : null;
                    ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
                    throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
                }
                FeignClientFlowReplaySpan feignClientSpan = (FeignClientFlowReplaySpan)span;
                if (this.isRequestEqual(feignClientSpan, method, args)) {
                    try {
                        Object mockRet = feignClientSpan.getReturnValue();
                        replayDetailSpan.setReturnValue(mockRet);
                        return mockRet;
                    }
                    catch (KryoException e) {
                        ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_207, e);
                    }
                }
                throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
            }
            return this.invokeMethodInner(method, this.original, args);
        }

        private FeignClientFlowReplaySpan createReplayDetailSpan(Method method, Object[] args, FlowReplaySpan span) {
            FeignClientFlowReplaySpan replayDetailSpan = FeignClientFlowReplaySpan.createSpan(method, args, null);
            replayDetailSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());
            if (span != null) {
                replayDetailSpan.setSpanId(span.getSpanId());
            }
            FlowReplayTrace.addSubSpan(replayDetailSpan);
            return replayDetailSpan;
        }

        private boolean isRequestEqual(FeignClientFlowReplaySpan feignClientSpan, Method currentMethod, Object[] currentArgs) {
            if (!this.isTypeFullPathEqual(feignClientSpan, currentMethod)) {
                String expert = feignClientSpan.getTypeFullPath();
                String actual = currentMethod.getDeclaringClass().getName();
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_205, expert, actual);
                return false;
            }
            if (!this.isApiNameEqual(feignClientSpan, currentMethod)) {
                String expert = feignClientSpan.getMethodName();
                String actual = currentMethod.getName();
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_201, expert, actual);
                return false;
            }
            if (!this.isParameterTypesEqual(feignClientSpan, currentMethod)) {
                String expert = FlowReplayUtils.stringArrayToString(feignClientSpan.getParameterTypes());
                String actual = FlowReplayUtils.classArrayToString(currentMethod.getParameterTypes());
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_202, expert, actual);
                return false;
            }
            try {
                if (!this.isParameterValuesEqual(feignClientSpan, currentArgs)) {
                    ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_203);
                    return false;
                }
            }
            catch (KryoException e) {
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_206, e);
                return false;
            }
            if (!this.isReturnTypeEqual(feignClientSpan, currentMethod)) {
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_204);
                return false;
            }
            return true;
        }

        private boolean isTypeFullPathEqual(FeignClientFlowReplaySpan feignClientSpan, Method currentMethod) {
            String spanTypeFullPath = feignClientSpan.getTypeFullPath();
            String currentTypeFullPath = currentMethod.getDeclaringClass().getName();
            return Objects.equals(spanTypeFullPath, currentTypeFullPath);
        }

        private boolean isApiNameEqual(FeignClientFlowReplaySpan feignClientSpan, Method currentMethod) {
            String spanApiName = feignClientSpan.getApiName();
            String currentApiName = FlowReplayUtils.parseApiNameByMethod(currentMethod);
            return Objects.equals(spanApiName, currentApiName);
        }

        private boolean isParameterTypesEqual(FeignClientFlowReplaySpan feignClientSpan, Method currentMethod) {
            String[] spanParameterTypes = feignClientSpan.getParameterTypes();
            Class<?>[] currentParameterTypes = currentMethod.getParameterTypes();
            int currentLength = currentParameterTypes.length;
            String[] currentParameterTypeNames = null;
            if (currentLength > 0) {
                currentParameterTypeNames = new String[currentLength];
                for (int i = 0; i < currentLength; ++i) {
                    currentParameterTypeNames[i] = currentParameterTypes[i].getName();
                }
            }
            return Objects.deepEquals(spanParameterTypes, currentParameterTypeNames);
        }

        private boolean isParameterValuesEqual(FeignClientFlowReplaySpan feignClientSpan, Object[] currentArgs) {
            Object[] spanParameterValues = feignClientSpan.getParameterValues();
            if (Objects.deepEquals(spanParameterValues, currentArgs)) {
                return true;
            }
            for (int i = 0; i < spanParameterValues.length; ++i) {
                Object spanObj = spanParameterValues[i];
                Object currentObj = currentArgs[i];
                if (FlowReplayUtils.isObjectEqual(spanObj, currentObj)) continue;
                return false;
            }
            return true;
        }

        private boolean isReturnTypeEqual(FeignClientFlowReplaySpan feignClientSpan, Method currentMethod) {
            String spanReturnType = feignClientSpan.getReturnType();
            return Objects.equals(spanReturnType, currentMethod.getReturnType().getName());
        }
    }

    public static class FlowRecordFeignClientInvocationHandler
    extends FlowReplayInvocationHandler {
        FlowRecordFeignClientInvocationHandler(Object original) {
            super(original);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object ret;
            String methodName = method.getName();
            if ("equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName) || method.isDefault() || !FlowReplayTrace.isTraced() || IgnoreSubInvokesContext.isMarked()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            IgnoreSubInvokesContext.instMark(this.original, method.getName(), args);
            try {
                ret = this.invokeMethodInner(method, this.original, args);
            }
            catch (Throwable t) {
                if (FlowReplayTrace.isTraced()) {
                    FlowReplayTrace.remove();
                    IgnoreSubInvokesContext.unmark();
                }
                throw t;
            }
            try {
                FeignClientFlowReplaySpan span = FeignClientFlowReplaySpan.createSpan(method, args, ret);
                span.setTraceId(FlowReplayTrace.getCurrentTraceId());
                FlowReplayTrace.addSubSpan(span);
            }
            catch (Throwable t) {
                log.error("feignClient\u5f55\u5236\u5f02\u5e38", t);
            }
            finally {
                IgnoreSubInvokesContext.unmark();
            }
            return ret;
        }
    }

    public static abstract class FlowReplayInvocationHandler
    implements InvocationHandler {
        protected final Object original;

        FlowReplayInvocationHandler(Object original) {
            this.original = original;
        }

        protected Object invokeMethodInner(Method method, Object target, Object[] args) throws Throwable {
            try {
                return method.invoke(target, args);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if (e instanceof HystrixBadRequestException && e.getCause() != null && e.getCause() instanceof BizException) {
                    e = e.getCause();
                }
                throw e;
            }
        }
    }
}

