/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.nustaq.serialization.util;

import shaded.org.nustaq.serialization.util.FSTObject2IntMap;
import shaded.org.nustaq.serialization.util.FSTUtil;

public class FSTMap<K, V> {
    static int[] prim = FSTObject2IntMap.prim;
    private static final int GROFAC = 2;
    public Object[] mKeys;
    public Object[] mValues;
    public int mNumberOfElements;
    FSTMap<K, V> next;
    boolean checkClazzOnEquals = false;
    static int miss = 0;
    static int hit = 0;

    public static int adjustSize(int size) {
        for (int i = 0; i < prim.length - 1; ++i) {
            if (size >= prim[i]) continue;
            return prim[i];
        }
        return size;
    }

    public FSTMap(int initialSize) {
        if (initialSize < 2) {
            initialSize = 2;
        }
        initialSize = FSTMap.adjustSize(initialSize * 2);
        this.mKeys = new Object[initialSize];
        this.mValues = new Object[initialSize];
        this.mNumberOfElements = 0;
    }

    public int size() {
        return this.mNumberOfElements + (this.next != null ? this.next.size() : 0);
    }

    public final void put(K key, V value) {
        int hash = key.hashCode() & Integer.MAX_VALUE;
        this.putHash(key, value, hash, this);
    }

    final void putHash(K key, V value, int hash, FSTMap<K, V> parent) {
        int idx;
        if (this.mNumberOfElements * 2 > this.mKeys.length) {
            if (parent != null) {
                if ((parent.mNumberOfElements + this.mNumberOfElements) * 2 > parent.mKeys.length) {
                    parent.resize(parent.mKeys.length * 2);
                    parent.put(key, value);
                    return;
                }
                this.resize(this.mKeys.length * 2);
            } else {
                this.resize(this.mKeys.length * 2);
            }
        }
        if (this.mKeys[idx = hash % this.mKeys.length] == null) {
            ++this.mNumberOfElements;
            this.mValues[idx] = value;
            this.mKeys[idx] = key;
        } else if (this.mKeys[idx].equals(key) && (!this.checkClazzOnEquals || this.mKeys[idx].getClass() == key.getClass())) {
            this.mValues[idx] = value;
        } else {
            this.putNext(hash, key, value);
        }
    }

    final K removeHash(K key, int hash) {
        int idx = hash % this.mKeys.length;
        Object mKey = this.mKeys[idx];
        if (mKey == null) {
            return null;
        }
        if (mKey.equals(key) && (!this.checkClazzOnEquals || this.mKeys[idx].getClass() == key.getClass())) {
            Object val = this.mKeys[idx];
            this.mValues[idx] = 0;
            this.mKeys[idx] = null;
            --this.mNumberOfElements;
            return (K)val;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.removeHash(key, hash);
    }

    final void putNext(int hash, K key, V value) {
        if (this.next == null) {
            int newSiz = this.mNumberOfElements / 3;
            this.next = new FSTMap<K, V>(newSiz);
        }
        this.next.putHash(key, value, hash, this);
    }

    public final V get(K key) {
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int idx = hash % this.mKeys.length;
        Object mapsKey = this.mKeys[idx];
        if (mapsKey == null) {
            return null;
        }
        if (mapsKey.equals(key) && (!this.checkClazzOnEquals || mapsKey.getClass() == key.getClass())) {
            return (V)this.mValues[idx];
        }
        if (this.next == null) {
            return null;
        }
        V res = this.next.getHash(key, hash);
        return res;
    }

    final V getHash(K key, int hash) {
        int idx = hash % this.mKeys.length;
        Object mapsKey = this.mKeys[idx];
        if (mapsKey == null) {
            return null;
        }
        if (mapsKey.equals(key) && (!this.checkClazzOnEquals || mapsKey.getClass() == key.getClass())) {
            return (V)this.mValues[idx];
        }
        if (this.next == null) {
            return null;
        }
        V res = this.next.getHash(key, hash);
        return res;
    }

    final void resize(int newSize) {
        newSize = FSTMap.adjustSize(newSize);
        Object[] oldTabKey = this.mKeys;
        Object[] oldTabVal = this.mValues;
        this.mKeys = new Object[newSize];
        this.mValues = new Object[newSize];
        this.mNumberOfElements = 0;
        for (int n = 0; n < oldTabKey.length; ++n) {
            if (oldTabKey[n] == null) continue;
            this.put(oldTabKey[n], oldTabVal[n]);
        }
        if (this.next != null) {
            FSTMap<K, V> oldNext = this.next;
            this.next = null;
            super.rePut(this);
        }
    }

    private void rePut(FSTMap<K, V> kfstObject2IntMap) {
        for (int i = 0; i < this.mKeys.length; ++i) {
            Object mKey = this.mKeys[i];
            if (mKey == null) continue;
            kfstObject2IntMap.put(mKey, this.mValues[i]);
        }
        if (this.next != null) {
            super.rePut(kfstObject2IntMap);
        }
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        FSTUtil.clear(this.mKeys);
        FSTUtil.clear(this.mValues);
        this.mNumberOfElements = 0;
        if (this.next != null) {
            this.next.clear();
        }
    }
}

