package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import java.time.Instant;
import java.util.concurrent.ConcurrentMap;

import com.google.common.collect.Maps;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;

/**
 * Created by hujinliang on 2018/1/17.
 */
public class HystrixPropertiesStrategyWithReloadableCache extends HystrixPropertiesStrategy {
    private static final ConcurrentMap<String, Long> concurrentMap = Maps.newConcurrentMap();

    @Override
    public String getCommandPropertiesCacheKey(HystrixCommandKey commandKey, HystrixCommandProperties.Setter builder) {
        if (!concurrentMap.containsKey(commandKey.name())) {
            concurrentMap.put(commandKey.name(), Instant.now().toEpochMilli());
        }
        return String.format("%s-%d", commandKey.name(), concurrentMap.get(commandKey.name()));
    }

    public static void updateHystrixSettings(String commandKey) {
        concurrentMap.put(commandKey, Instant.now().toEpochMilli());
    }
}
