package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.web.container.TomcatIpRecordValve;
import com.google.common.base.Joiner;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpMethod;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.*;

/**
 * Spring Mvc Controller 类型的 Span
 * Created by guoyanfei .
 * 2019-01-24 .
 */
public class SpringMvcFlowReplaySpan extends FlowReplaySpan {

    private static final long serialVersionUID = -3775118543698169978L;

    private HttpMethod method;

    private String uri;

    private String springBestMatchingUri;

    private Map<String, String> headers;

    private Map<String, String[]> parameters;

    private byte[] requestBody;

    private byte[] responseBody;

    @Override
    public SpanType getSpanType() {
        return SpanType.SPRING_MVC;
    }

    /**
     * 创建span
     * @param request
     * @return
     */
    public static SpringMvcFlowReplaySpan createSpan(HttpServletRequest request) throws IOException {
        SpringMvcFlowReplaySpan span = new SpringMvcFlowReplaySpan();

        Map<String, String> headers = new HashMap<>();
        Enumeration<String> headNames = request.getHeaderNames();
        while (headNames.hasMoreElements()) {
            String headName = headNames.nextElement();
            Enumeration<String> h = request.getHeaders(headName);
            List<String> hs = new ArrayList<>();
            while (h.hasMoreElements()) {
                hs.add(h.nextElement());
            }
            headers.put(headName, Joiner.on(";").join(hs));
        }
        headers.put("X-Forwarded-For", (String) request.getAttribute(TomcatIpRecordValve.ORIGINAL_X_FORWARDED_FOR));

        span.setSpanId(UUIDUtils.createUUID());
        span.method = HttpMethod.resolve(request.getMethod());
        span.uri = request.getRequestURI();
        span.headers = headers;
        span.parameters = request.getParameterMap();
        span.springBestMatchingUri = null; // 此处还获取不到
        span.requestBody = IOUtils.toByteArray(request.getInputStream());
        return span;
    }

    public void setResponseBody(byte[] responseBody) throws IOException {
        this.responseBody = responseBody;
    }

    public void setSpringBestMatchingUri(String springBestMatchingUri) {
        this.springBestMatchingUri = springBestMatchingUri;
    }

    public HttpMethod getMethod() {
        return method;
    }

    public String getUri() {
        return uri;
    }

    public String getSpringBestMatchingUri() {
        return springBestMatchingUri;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public Map<String, String[]> getParameters() {
        return parameters;
    }

    public byte[] getRequestBody() {
        return requestBody;
    }

    public byte[] getResponseBody() {
        return responseBody;
    }
}
