package cn.com.duibaboot.ext.autoconfigure.grouping;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/**
 * 服务分组标识获取的工具类
 * 目前用于支持需求：http://cf.dui88.com/pages/viewpage.action?pageId=11134823
 * Created by guoyanfei .
 * 2018/11/7 .
 */
@Slf4j
public final class ServiceGroupUtils {

    private ServiceGroupUtils() {
    }

    public static final String DUIBA_SERVICE_GROUP_KEY = "_duibaServiceGroupKey";
    //开发环境获取ip作为服务分组id，以实现优先调用开发者本地服务的逻辑,以提升开发效率
    public static final String DUIBA_SERVICE_GROUP_IP_PREFIX = "dev_ip_";

    /**
     * 从request中获取服务分组标识，服务分组标识可以再以下任一地方
     * <br/>
     * cookie 中有 _duibaServiceGroupKey
     * <br/>
     * header 中有 _duibaServiceGroupKey
     * @param request
     * @return 服务分组标识，可能为nul
     */
    public static String getDuibaServiceGroupKey(HttpServletRequest request) {
        String groupKey = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (DUIBA_SERVICE_GROUP_KEY.equals(cookie.getName())) {
                    groupKey = cookie.getValue();
                }
            }
        }
        if (StringUtils.isBlank(groupKey)) {
            groupKey = request.getHeader(DUIBA_SERVICE_GROUP_KEY);
        }
        return groupKey;
    }
}
