package cn.com.duibaboot.ext.autoconfigure.web;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStatusHolder {

    private static final Logger log = LoggerFactory.getLogger(ServerStatusHolder.class);

    //刚启动不提供服务，等待InitServerAutoConfiguration.SpringMvcInitConfiguration 调用过一次本服务后再开启服务。（这样做是因为首次web访问比较慢，需要先预热一下。）
    private static volatile boolean inService = false;

    private static List<ServiceStatusChangedListener> serviceStatusChangedListeners
            = new CopyOnWriteArrayList<>();

    public static boolean isInService() {
        return inService;
    }

    /**
     * 设置服务状态。
     * @param inService
     */
    public static synchronized void setInService(boolean inService){
        ServerStatusHolder.inService = inService;
        for(ServiceStatusChangedListener listener : serviceStatusChangedListeners){
            try {
                listener.onServiceStatusChanged(inService);
            }catch(Throwable e){
                log.warn("Call ServiceStatusChangedListener error:", e);
            }
        }
    }

    /**
     * 注册服务状态变更监听器
     * @param listener
     */
    public static void registerServiceStatusChangedListener(ServiceStatusChangedListener listener){
        if(!serviceStatusChangedListeners.contains(listener)) {
            serviceStatusChangedListeners.add(listener);
        }
    }

    /**
     * 取消注册服务状态变更监听器
     * @param listener
     */
    public static void unregisterServiceStatusChangedListener(ServiceStatusChangedListener listener){
        serviceStatusChangedListeners.remove(listener);
    }

    public interface ServiceStatusChangedListener {
        void onServiceStatusChanged(boolean isInService);
    }

}
